<?php

namespace App\Helpers;

use Illuminate\Support\Facades\Auth;

class RoleHelper
{
    public static function userRole()
    {

        return Auth::user()?->role;
    }

    public static function isOwnerOrAdmin(): bool
    {
        return in_array(self::userRole(), ['owner', 'admin'], true);
    }

    public static function canSeePatients(): bool
    {
        return in_array(self::userRole(), ['owner', 'admin', 'doctor', 'receptionist', 'nurse'], true);
    }

    public static function canSeeDoctors(): bool
    {
        return in_array(self::userRole(), ['owner', 'admin'], true);
    }

    public static function canSeeInvoices(): bool
    {
        return in_array(self::userRole(), ['owner', 'admin', 'receptionist', 'accountant'], true);
    }

    public static function canSeeInventory(): bool
    {
        return in_array(self::userRole(), ['owner', 'admin'], true);
    }

    public static function canSeeSettings(): bool
    {
        return in_array(self::userRole(), ['owner', 'admin'], true);
    }
}
