<?php

namespace App\Http\Controllers\Treatment;

use App\Http\Controllers\Controller;
use App\Models\DoctorProfiles;
use App\Models\Patients;
use App\Models\Services;
use App\Models\TreatmentPlans;
use Illuminate\Http\Request;

class TreatmentPlanController extends Controller
{
    public function index()
    {
        $plans = TreatmentPlans::with('patient', 'doctor.user')->latest()->paginate(20);
        return view('admin.treatment-plans.index', compact('plans'));
    }

    public function create($patient_id)
    {

        $patient  = Patients::findOrFail($patient_id);
        $doctors  = DoctorProfiles::with('user')->get();

        return view('admin.treatment-plans.create', compact('patient', 'doctors'));
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'patient_id'  => 'required|exists:patients,id',
            'doctor_id'   => 'required|exists:doctor_profiles,id',
            'title'       => 'nullable|string',
            'description' => 'nullable|string',
            'status'      => 'nullable|in:draft,ongoing,completed,cancelled',
        ]);

        $data['status'] = $data['status'] ?? 'draft';

        $plan = TreatmentPlans::create($data);

        return redirect()->route('treatment-plans.show', $plan->id)
            ->with('success', 'تم إنشاء خطة العلاج بنجاح');
    }

    public function show($id)
    {
        $plan = TreatmentPlans::with([
            'patient',
            'doctor.user',
            'items.service',
            'items.visit'
        ])->findOrFail($id);

        $services = Services::where('clinic_id', auth()->user()->clinic_id)->where('is_active',true)->get();

        return view('admin.treatment-plans.show', compact('plan', 'services'));
    }

    public function updateStatus(Request $request, $id)
    {
        $plan = TreatmentPlans::findOrFail($id);

        $data = $request->validate([
            'status' => 'required|in:draft,ongoing,completed,cancelled',
        ]);

        $plan->status = $data['status'];
        $plan->save();

        return back()->with('success', 'تم تحديث حالة خطة العلاج بنجاح.');
    }

    public function destroy($id)
    {
        $plan = TreatmentPlans::findOrFail($id);
        $plan->delete();

        return redirect()->route('treatment-plans.index')->with('success','تم الحذف بنجاح ');
    }
}
