<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class RoleAccess
{

    public function handle(Request $request, Closure $next, ...$roles)
    {

        $user = Auth::user();

        if (! $user) {
            abort(403, 'غير مصرح لك بالدخول.');
        }

        if (empty($roles)) {
            return $next($request);
        }

        if (! in_array($user->role, $roles, true)) {

            abort(403, 'ليست لديك صلاحية لعرض هذه الصفحة.');
        }

        return $next($request);
    }
}
