<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Attachments extends Model
{
    use HasFactory;

    protected $fillable = [
        'patient_id',
        'visit_id',
        'file_path',
        'file_type',
        'description',
    ];

    public function patient()
    {
        return $this->belongsTo(Patients::class, 'patient_id');
    }

    public function visit()
    {
        return $this->belongsTo(Visits::class, 'visit_id');
    }
}
