<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MedicalRecords extends Model
{
    use HasFactory;

    protected $fillable = [
        'patient_id',
        'blood_type',
        'chronic_diseases',
        'allergies',
        'current_medications',
        'surgical_history',
        'family_history',
    ];

    public function patient()
    {
        return $this->belongsTo(Patients::class, 'patient_id');
    }
}
