<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Services extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'clinic_id',
        'specialty_id',
        'name',
        'category',
        'default_price',
        'duration_minutes',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function clinic()
    {
        return $this->belongsTo(Clinic::class, 'clinic_id');
    }

    public function specialty()
    {
        return $this->belongsTo(Specialties::class, 'specialty_id');
    }

    public function treatmentPlanItems()
    {
        return $this->hasMany(TreatmentPlanItems::class, 'service_id');
    }

    public function invoiceItems()
    {
        return $this->hasMany(InvoiceItems::class, 'service_id');
    }



    public function inventoryLinks()
    {
        return $this->hasMany(ServiceInventoryItem::class, 'service_id');
    }

    public function inventoryItems()
    {
        return $this->belongsToMany(InventoryItems::class, 'service_inventory_items', 'service_id', 'inventory_item_id')
            ->withPivot('quantity_per_service')
            ->withTimestamps();
    }

}
