<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StockMovements extends Model
{
    use HasFactory;

    protected $fillable = [
        'inventory_item_id',
        'branch_id',
        'type',
        'quantity',
        'reason',
        'reference_type',
        'reference_id',
    ];

    public function inventoryItem()
    {
        return $this->belongsTo(InventoryItems::class, 'inventory_item_id');
    }

    public function branch()
    {
        return $this->belongsTo(Branches::class, 'branch_id');
    }
}
