<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Visits extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'clinic_id',
        'branch_id',
        'patient_id',
        'doctor_id',
        'appointment_id',
        'visit_date',
        'status',
        'chief_complaint',
        'diagnosis',
        'next_visit_date',
    ];

    protected $casts = [
        'visit_date'      => 'datetime',
        'next_visit_date' => 'datetime',
    ];

    public function clinic()
    {
        return $this->belongsTo(Clinic::class, 'clinic_id');
    }

    public function branch()
    {
        return $this->belongsTo(Branches::class, 'branch_id');
    }

    public function patient()
    {
        return $this->belongsTo(Patients::class, 'patient_id');
    }

    public function doctor()
    {
        return $this->belongsTo(DoctorProfiles::class, 'doctor_id');
    }

    public function appointment()
    {
        return $this->belongsTo(Appointment::class, 'appointment_id');
    }

    public function prescriptions()
    {
        return $this->hasMany(Prescriptions::class, 'visit_id');
    }

    public function treatmentPlanItems()
    {
        return $this->hasMany(TreatmentPlanItems::class, 'visit_id');
    }

    public function attachments()
    {
        return $this->hasMany(Attachments::class, 'visit_id');
    }

    public function invoice()
    {
        return $this->hasOne(Invoices::class, 'visit_id');
    }
}
