<?php

namespace App\Services;

use App\Models\InventoryItems;
use App\Models\StockMovements;
use Illuminate\Support\Facades\DB;

class StockService
{
    public function increaseStock(
        int $inventoryItemId,
        int|float $quantity,
        ?int $branchId = null,
        ?string $reason = null,
        ?string $referenceType = null,
        ?int $referenceId = null
    ): void {
        DB::transaction(function () use ($inventoryItemId, $quantity, $branchId, $reason, $referenceType, $referenceId) {

            $item = InventoryItems::lockForUpdate()->findOrFail($inventoryItemId);

            $item->current_quantity += $quantity;
            $item->save();

            StockMovements::create([
                'inventory_item_id' => $item->id,
                'branch_id'        => $branchId,
                'type'             => 'in',
                'quantity'         => $quantity,
                'reason'           => $reason,
                'reference_type'   => $referenceType,
                'reference_id'     => $referenceId,
            ]);
        });
    }

    public function decreaseStock(
        int $inventoryItemId,
        int|float $quantity,
        ?int $branchId = null,
        ?string $reason = null,
        ?string $referenceType = null,
        ?int $referenceId = null
    ): void {
        DB::transaction(function () use ($inventoryItemId, $quantity, $branchId, $reason, $referenceType, $referenceId) {

            $item = InventoryItems::lockForUpdate()->findOrFail($inventoryItemId);

            if ($item->current_quantity < $quantity) {

            }

            $item->current_quantity -= $quantity;
            $item->save();

            StockMovements::create([
                'inventory_item_id' => $item->id,
                'branch_id'        => $branchId,
                'type'             => 'out',
                'quantity'         => $quantity,
                'reason'           => $reason,
                'reference_type'   => $referenceType,
                'reference_id'     => $referenceId,
            ]);
        });
    }

    public function adjustStock(
        int $inventoryItemId,
        int|float $newQuantity,
        ?int $branchId = null,
        ?string $reason = null,
        ?string $referenceType = null,
        ?int $referenceId = null
    ): void {
        DB::transaction(function () use ($inventoryItemId, $newQuantity, $branchId, $reason, $referenceType, $referenceId) {
            $item = InventoryItems::lockForUpdate()->findOrFail($inventoryItemId);

            $difference = $newQuantity - $item->current_quantity;

            $item->current_quantity = $newQuantity;
            $item->save();

            StockMovements::create([
                'inventory_item_id' => $item->id,
                'branch_id'        => $branchId,
                'type'             => 'adjustment',
                'quantity'         => $difference,
                'reason'           => $reason ?? 'جرد / تعديل يدوي',
                'reference_type'   => $referenceType,
                'reference_id'     => $referenceId,
            ]);
        });
    }
}
