<?php

namespace Database\Seeders;

use App\Models\ActivityLogs;
use Illuminate\Database\Seeder;
use App\Models\Clinic;
use App\Models\User;

class ActivityLogSeeder extends Seeder
{
    public function run(): void
    {
        ActivityLogs::create([
            'clinic_id'   => Clinic::first()->id,
            'user_id'     => User::where('role', 'owner')->first()->id,
            'action'      => 'system_init',
            'description' => 'Initial data seeded for Dental Care Clinic.',
            'ip_address'  => '127.0.0.1',
        ]);
    }
}
