<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    use WithoutModelEvents;

    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $this->call([
            ClinicSeeder::class,
            BranchSeeder::class,
            SpecialtySeeder::class,
            UserSeeder::class,
            DoctorProfileSeeder::class,
            PatientSeeder::class,
            MedicalRecordSeeder::class,
            AppointmentSeeder::class,
            VisitSeeder::class,

            ServiceSeeder::class,
            TreatmentPlanSeeder::class,
            TreatmentPlanItemSeeder::class,

            MedicationSeeder::class,
            PrescriptionSeeder::class,
            PrescriptionItemSeeder::class,

            InvoiceSeeder::class,
            InvoiceItemSeeder::class,
            PaymentSeeder::class,

            InventoryItemSeeder::class,
            StockMovementSeeder::class,

            SettingsSeeder::class,
            ActivityLogSeeder::class,
        ]);
    }
}
