<?php

namespace Database\Seeders;

use App\Models\Branches;
use App\Models\DoctorProfiles;
use App\Models\Specialties;
use Illuminate\Database\Seeder;
use App\Models\User;

class DoctorProfileSeeder extends Seeder
{
    public function run(): void
    {
        DoctorProfiles::create([
            'user_id' => User::where('role', 'doctor')->first()->id,
            'specialty_id' => Specialties::where('name', 'Dentistry')->first()->id,
            'branch_id' => Branches::first()->id,
            'title' => 'Dentist',
            'bio' => 'Expert in dental care and cosmetic dentistry.',
            'consultation_fee' => 200,
            'followup_fee' => 100,
            'commission_type' => 'percentage',
            'commission_value' => 25,
        ]);
    }
}
