<?php

namespace Database\Seeders;

use App\Models\InventoryItems;
use Illuminate\Database\Seeder;
use App\Models\Clinic;

class InventoryItemSeeder extends Seeder
{
    public function run(): void
    {
        $clinic = Clinic::first();

        InventoryItems::insert([
            [
                'clinic_id'        => $clinic->id,
                'name'             => 'Composite Filling Material',
                'category'         => 'consumable',
                'unit'             => 'syringe',
                'sku'              => 'COMP-001',
                'min_quantity'     => 5,
                'current_quantity' => 20,
                'purchase_price'   => 150,
                'sale_price'       => 250,
            ],
            [
                'clinic_id'        => $clinic->id,
                'name'             => 'Gloves (Box)',
                'category'         => 'consumable',
                'unit'             => 'box',
                'sku'              => 'GLOVES-BOX',
                'min_quantity'     => 10,
                'current_quantity' => 50,
                'purchase_price'   => 50,
                'sale_price'       => 0,
            ],
        ]);
    }
}
