<?php

namespace Database\Seeders;

use App\Models\InvoiceItems;
use App\Models\Invoices;
use App\Models\Services;
use Illuminate\Database\Seeder;

class InvoiceItemSeeder extends Seeder
{
    public function run(): void
    {
        $invoice   = Invoices::first();

        $consult   = Services::where('name', 'Dental Consultation')->first();
        $clean     = Services::where('name', 'Teeth Cleaning')->first();
        $filling   = Services::where('name', 'Tooth Filling')->first();

        InvoiceItems::create([
            'invoice_id' => $invoice->id,
            'service_id' => $consult?->id,
            'description'=> 'Dental Consultation',
            'quantity'   => 1,
            'unit_price' => 200,
            'discount'   => 0,
            'line_total' => 200,
        ]);

        InvoiceItems::create([
            'invoice_id' => $invoice->id,
            'service_id' => $clean?->id,
            'description'=> 'Teeth Cleaning',
            'quantity'   => 1,
            'unit_price' => 400,
            'discount'   => 0,
            'line_total' => 400,
        ]);

        InvoiceItems::create([
            'invoice_id' => $invoice->id,
            'service_id' => $filling?->id,
            'description'=> 'Tooth Filling (tooth 26)',
            'quantity'   => 1,
            'unit_price' => 600,
            'discount'   => 50,
            'line_total' => 550,
        ]);
    }
}
