<?php

namespace Database\Seeders;

use App\Models\Branches;
use App\Models\Clinic;
use App\Models\Invoices;
use App\Models\Patients;
use App\Models\TreatmentPlans;
use App\Models\Visits;
use Illuminate\Database\Seeder;


class InvoiceSeeder extends Seeder
{
    public function run(): void
    {
        $clinic  = Clinic::first();
        $branch  = Branches::first();
        $patient = Patients::first();
        $visit   = Visits::first();
        $plan    = TreatmentPlans::first();

        // هنفترض إن إجمالي الخطة = 200 + 400 + (600 - 50) = 1,150
        Invoices::create([
            'clinic_id'         => $clinic->id,
            'branch_id'         => $branch->id,
            'patient_id'        => $patient->id,
            'visit_id'          => $visit->id,
            'treatment_plan_id' => $plan->id,
            'invoice_number'    => 'INV-0001',
            'date'              => now()->format('Y-m-d'),
            'subtotal'          => 1150,
            'discount'          => 50,
            'tax_percent'       => 0,
            'tax_amount'        => 0,
            'total'             => 1100,
            'paid_amount'       => 600,   // لسه باقي 500
            'status'            => 'partial',
            'payment_due_date'  => now()->addDays(7)->format('Y-m-d'),
        ]);
    }
}
