<?php

namespace Database\Seeders;

use App\Models\Branches;
use App\Models\Patients;
use Carbon\Carbon;
use Illuminate\Database\Seeder;

use App\Models\Clinic;
use Illuminate\Support\Facades\DB;

class PatientSeeder extends Seeder
{
    public function run(): void
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Db::table('patients')->truncate();

        for ($i = 0; $i < 90; $i++) {
            Patients::create([
                'clinic_id' => Clinic::first()->id,
                'branch_id' => Branches::first()->id,
                'code' => 'PAT-000' . $i,
                'first_name' => fake()->name(),
                'last_name' => fake()->name(),
                'gender' => fake()->randomElement(['male', 'female']),
                'birth_date' => fake()->date(),
                'phone' => '0112233445' . $i,
                'national_id' => '2991234567890' . $i,
            ]);
        }
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }
}
