<?php

namespace Database\Seeders;

use App\Models\Medications;
use App\Models\PrescriptionItems;
use App\Models\Prescriptions;
use Illuminate\Database\Seeder;


class PrescriptionItemSeeder extends Seeder
{
    public function run(): void
    {
        $prescription = Prescriptions::first();
        $amox   = Medications::where('name', 'Amoxicillin 500mg')->first();
        $ibuprofen = Medications::where('name', 'Ibuprofen 400mg')->first();

        PrescriptionItems::create([
            'prescription_id' => $prescription->id,
            'medication_id'   => $amox?->id,
            'dose'            => '1 capsule',
            'frequency'       => 'every 8 hours',
            'duration'        => '5 days',
            'instructions'    => 'After meals',
        ]);

        PrescriptionItems::create([
            'prescription_id' => $prescription->id,
            'medication_id'   => $ibuprofen?->id,
            'dose'            => '1 tablet',
            'frequency'       => 'every 12 hours',
            'duration'        => '3 days',
            'instructions'    => 'If pain is severe',
        ]);
    }
}
