<?php

namespace Database\Seeders;

use App\Models\Services;
use App\Models\Specialties;
use Illuminate\Database\Seeder;

use App\Models\Clinic;


class ServiceSeeder extends Seeder
{
    public function run(): void
    {
        $clinic = Clinic::first();
        $dentistry = Specialties::where('name', 'Dentistry')->first();

        Services::insert([
            [
                'clinic_id'     => $clinic->id,
                'specialty_id'  => $dentistry?->id,
                'name'          => 'Dental Consultation',
                'category'      => 'consultation',
                'default_price' => 200,
                'duration_minutes' => 30,
                'is_active'     => true,
            ],
            [
                'clinic_id'     => $clinic->id,
                'specialty_id'  => $dentistry?->id,
                'name'          => 'Tooth Filling',
                'category'      => 'procedure',
                'default_price' => 600,
                'duration_minutes' => 45,
                'is_active'     => true,
            ],
            [
                'clinic_id'     => $clinic->id,
                'specialty_id'  => $dentistry?->id,
                'name'          => 'Teeth Cleaning',
                'category'      => 'procedure',
                'default_price' => 400,
                'duration_minutes' => 40,
                'is_active'     => true,
            ],
        ]);
    }
}
