<?php

namespace Database\Seeders;

use App\Models\Branches;
use App\Models\DoctorProfiles;
use App\Models\Specialties;
use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Clinic;

use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    public function run(): void
    {
        $clinic = Clinic::first();
        $branch = Branches::first();

        // Owner
        User::create([
            'clinic_id' => $clinic->id,
            'branch_id' => $branch->id,
            'name' => 'System Owner',
            'phone' => fake()->phoneNumber(),
            'email' => 'owner@clinic.test',
            'password' => Hash::make('password'),
            'role' => 'owner',
        ]);


        for ($i = 0, $ii = 20; $i < $ii; $i++) {

            // Doctor
            $user = User::create([
                'clinic_id' => $clinic->id,
                'branch_id' => $branch->id,
                'name' => fake()->name(),
                'phone' => fake()->phoneNumber(),
                'email' => fake()->email(),
                'password' => Hash::make('password'),
                'role' => 'doctor',
            ]);

            DoctorProfiles::create([
                'user_id' => $user->id,
                'branch_id' => $branch->id,
                'specialty_id' => fake()->randomElement(Specialties::pluck('id')->toArray()),

            ]);

        }


        // Receptionist
        User::create([
            'clinic_id' => $clinic->id,
            'branch_id' => $branch->id,
            'name' => 'Reception Desk',
            'email' => 'reception@clinic.test',
            'phone' => fake()->phoneNumber(),
            'password' => Hash::make('password'),
            'role' => 'receptionist',
        ]);
    }
}
