<?php

namespace Database\Seeders;

use App\Models\Branches;
use App\Models\DoctorProfiles;
use App\Models\Patients;
use App\Models\Visits;
use Illuminate\Database\Seeder;
use App\Models\Clinic;
use App\Models\Appointment;
use Illuminate\Support\Facades\DB;

class VisitSeeder extends Seeder
{
    public function run(): void
    {


        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        DB::table('visits')->truncate();
        $patients = Patients::all();
        foreach ($patients as $patient) {
            Visits::create([
                'clinic_id' => Clinic::first()->id,
                'branch_id' => Branches::first()->id,
                'patient_id' =>$patient->id,
                'doctor_id' => DoctorProfiles::first()->id,
                'appointment_id' => Appointment::first()->id,
                'visit_date' => now(),
                'status' => 'completed',
                'chief_complaint' => 'Tooth pain',
                'diagnosis' => 'Cavity on molar',
            ]);
        }

        DB::statement('SET FOREIGN_KEY_CHECKS=1;');



    }
}
