@extends('admin.layouts.master')

@section('title')
    عرض بيانات الدكتور
@endsection
@section('content')

    @php
        $profile = $doctor->doctorProfile;
    @endphp

    <div class="row">
        <div class="col-lg-4">
            <div class="card shadow-sm mb-4">
                <div class="card-body text-center">

                    {{-- Avatar بسيط باسم الدكتور --}}
                    <img src="https://ui-avatars.com/api/?name={{ urlencode($doctor->name) }}&size=150"
                         class="rounded-circle mb-3" alt="Doctor Avatar">

                    <h4>{{ $doctor->name }}</h4>

                    <p class="text-muted mb-1">
                        {{ $profile?->specialty?->name ?? 'بدون تخصص محدد' }}
                    </p>

                    <p class="mb-2">
                        <strong>العيادة:</strong>
                        {{ $doctor->clinic?->name ?? '-' }}<br>

                        <strong>الفرع:</strong>
                        {{ $doctor->branch?->name ?? '-' }}
                    </p>

                    <p class="mb-2">
                        <strong>الحالة:</strong>
                        @if($doctor->is_active)
                            <span class="badge bg-success">نشط</span>
                        @else
                            <span class="badge bg-danger">غير نشط</span>
                        @endif
                    </p>

                    <hr>

                    <p class="mb-2">
                        <strong>البريد:</strong> {{ $doctor->email }} <br>
                        <strong>الجوال:</strong> {{ $doctor->phone ?? '-' }}
                    </p>

                    <p class="text-muted mb-0">
                        <small>تاريخ التسجيل: {{ $doctor->created_at?->format('Y-m-d') }}</small>
                    </p>

                    <hr>

                    <a href="{{ route('doctors.edit', $doctor->id) }}"
                       class="btn btn-primary w-100">
                        تعديل بيانات الدكتور
                    </a>
                </div>
            </div>
        </div>


        <div class="col-lg-8">

            <div class="card shadow-sm mb-4">
                <div class="card-header">
                    <ul class="nav nav-tabs card-header-tabs" id="doctorTabs" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active"
                                    id="appointments-tab"
                                    data-bs-toggle="tab"
                                    data-bs-target="#appointments-tab-pane"
                                    type="button" role="tab">
                                المواعيد
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link"
                                    id="visits-tab"
                                    data-bs-toggle="tab"
                                    data-bs-target="#visits-tab-pane"
                                    type="button" role="tab">
                                الزيارات
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link"
                                    id="prescriptions-tab"
                                    data-bs-toggle="tab"
                                    data-bs-target="#prescriptions-tab-pane"
                                    type="button" role="tab">
                                الروشتات
                            </button>
                        </li>
                    </ul>
                </div>

                <div class="card-body">
                    <div class="tab-content" id="doctorTabsContent">

                        {{-- Tab المواعيد --}}
                        <div class="tab-pane fade show active"
                             id="appointments-tab-pane"
                             role="tabpanel">

                            @if($profile && $appointments->count())
                                <div class="table-responsive">
                                    <table class="table table-sm table-striped align-middle">
                                        <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>المريض</th>
                                            <th>التاريخ</th>
                                            <th>الوقت</th>
                                            <th>الحالة</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($appointments as $app)
                                            <tr>
                                                <td>{{ $app->id }}</td>
                                                <td>{{ $app->patient?->first_name ?? '-' }}</td>
                                                <td>{{ $app->appointment_date }}</td>
                                                <td>{{ $app->start_time }}</td>
                                                <td>{{ $app->status }}</td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>

                                {{-- Pagination للمواعيد --}}
                                <div class="mt-2">
                                    {{ $appointments->links() }}
                                </div>
                            @else
                                <p class="text-center text-muted mb-0">
                                    لا توجد مواعيد مسجلة لهذا الطبيب.
                                </p>
                            @endif

                        </div>

                        {{-- Tab الزيارات --}}
                        <div class="tab-pane fade"
                             id="visits-tab-pane"
                             role="tabpanel">

                            @if($profile && $visits->count())
                                <div class="table-responsive">
                                    <table class="table table-sm table-striped align-middle">
                                        <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>المريض</th>
                                            <th>تاريخ الزيارة</th>
                                            <th>الحالة</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($visits as $visit)
                                            <tr>
                                                <td>{{ $visit->id }}</td>
                                                <td>{{ $visit->patient?->first_name ?? '-' }}</td>
                                                <td>{{ $visit->visit_date }}</td>
                                                <td>{{ $visit->status ?? '-' }}</td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>

                                {{-- Pagination للزيارات --}}
                                <div class="mt-2">
                                    {{ $visits->links() }}
                                </div>
                            @else
                                <p class="text-center text-muted mb-0">
                                    لا توجد زيارات مسجلة لهذا الطبيب.
                                </p>
                            @endif
                        </div>

                        {{-- Tab الروشتات --}}
                        <div class="tab-pane fade"
                             id="prescriptions-tab-pane"
                             role="tabpanel">

                            @if($profile && $prescriptions->count())

                                <div class="prescriptions-list">

                                    @foreach($prescriptions as $rx)

                                        <div class="card mb-3 shadow-sm">
                                            <div class="card-header d-flex justify-content-between align-items-center">

                                                <div>
                                                    <strong>روشتة رقم #{{ $rx->id }}</strong><br>
                                                    <small class="text-muted">
                                                        {{ $rx->created_at->format('Y-m-d H:i') }}
                                                        — للمريض:
                                                        {{ $rx->patient?->first_name ?? $rx->patient?->name ?? '-' }}
                                                    </small>
                                                </div>

                                                <div class="d-flex gap-1">
                                                    <button class="btn btn-sm btn-outline-primary"
                                                            onclick="document.getElementById('rx-{{ $rx->id }}').classList.toggle('d-none')">
                                                        عرض التفاصيل
                                                    </button>

                                                    <a href="{{ route('patients.prescriptions.print', $rx->id) }}"
                                                       target="_blank"
                                                       class="btn btn-sm btn-secondary">
                                                        طباعة
                                                    </a>
                                                </div>
                                            </div>

                                            <div class="card-body d-none" id="rx-{{ $rx->id }}">

                                                <div class="rx-text">
                                                    {!! nl2br(e($rx->notes)) !!}
                                                </div>

                                                {{-- لو عندك items للروشتة --}}
                                                @if($rx->items && $rx->items->count())
                                                    <hr>
                                                    <h6 class="fw-bold">الأدوية:</h6>
                                                    <ul class="list-group">
                                                        @foreach($rx->items as $item)
                                                            <li class="list-group-item">
                                                                <strong>{{ $item->name ?? $item->medication->name ?? '—' }}</strong><br>
                                                                @if($item->dosage)
                                                                    <small class="text-muted">الجرعة: {{ $item->dosage }}</small><br>
                                                                @endif
                                                                @if($item->instructions)
                                                                    <small class="text-muted">{{ $item->instructions }}</small>
                                                                @endif
                                                            </li>
                                                        @endforeach
                                                    </ul>
                                                @endif

                                            </div>
                                        </div>

                                    @endforeach

                                </div>

                                {{-- Pagination للروشتات --}}
                                <div class="mt-2">
                                    {{ $prescriptions->links() }}
                                </div>

                            @else
                                <p class="text-center text-muted mb-0">
                                    لا توجد روشتات مسجلة لهذا الطبيب.
                                </p>
                            @endif

                        </div>

                    </div>
                </div>
            </div>

        </div>

    </div>

@endsection
