@extends('admin.layouts.master')

@section('title')
    إضافة دكتور جديد
@endsection

@section('content')
    @php

        $selectedSpecialtyId = $selectedSpecialtyId ?? null;
    @endphp
    <div class="row">
        <div class="col-lg-12 offset-lg-2">

            <div class="card shadow-sm">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">إضافة دكتور جديد</h5>
                    <a href="{{ route('doctors.index') }}" class="btn btn-sm btn-secondary">
                        رجوع لقائمة الدكاترة
                    </a>
                </div>

                <div class="card-body">

                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <strong>خطأ!</strong> من فضلك تأكد من إدخال البيانات بشكل صحيح.
                            <ul class="mb-0 mt-2">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('doctors.store') }}" method="POST">
                        @csrf

                        {{-- بيانات أساسية --}}
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">اسم الدكتور *</label>
                                <input type="text" name="name" class="form-control"
                                       value="{{ old('name') }}" required>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label">البريد الإلكتروني *</label>
                                <input type="email" name="email" class="form-control"
                                       value="{{ old('email') }}" required>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">الجوال</label>
                                <input type="text" name="phone" class="form-control"
                                       value="{{ old('phone') }}">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label">كلمة المرور *</label>
                                <input type="password" name="password" class="form-control"
                                       placeholder="كلمة مرور حساب الدخول للدكتور" required>
                            </div>
                        </div>

                        {{-- التخصص والحالة --}}
                        <div class="col-md-6 mb-3">
                            <label class="form-label">التخصص *</label>

                            @if($selectedSpecialtyId)
                                <input type="hidden" name="specialty_id" value="{{ $selectedSpecialtyId }}">

                                <input type="text" class="form-control"
                                       value="{{ $specialties->firstWhere('id', $selectedSpecialtyId)?->name }}"
                                       disabled>
                            @else
                                <select name="specialty_id" class="form-select" required>
                                    <option value="">اختر التخصص</option>
                                    @foreach($specialties as $specialty)
                                        <option value="{{ $specialty->id }}"
                                            {{ old('specialty_id') == $specialty->id ? 'selected' : '' }}>
                                            {{ $specialty->name }}
                                        </option>
                                    @endforeach
                                </select>
                            @endif
                        </div>


                        {{-- معلومات العيادة/الفرع (للعرض فقط من المستخدم الحالي) --}}
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">العيادة</label>
                                <input type="text" class="form-control"
                                       value="{{ $user->clinic?->name ?? '-' }}" disabled>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">الفرع</label>
                                <input type="text" class="form-control"
                                       value="{{ $user->branch?->name ?? '-' }}" disabled>
                            </div>
                        </div>

                        <div class="d-flex justify-content-end mt-3">
                            <button type="submit" class="btn btn-success">
                                حفظ الدكتور
                            </button>
                        </div>

                    </form>

                </div>
            </div>

        </div>
    </div>

@endsection

@push('scripts')
    <script>
        // تغيير نص الحالة جنب الـ switch
        const isActiveSwitch = document.getElementById('is_active_switch');
        const isActiveLabel  = document.querySelector('label[for="is_active_switch"]');

        if (isActiveSwitch && isActiveLabel) {
            isActiveSwitch.addEventListener('change', function () {
                isActiveLabel.textContent = this.checked ? 'نشط' : 'غير نشط';
            });
        }
    </script>
@endpush
