@extends('admin.layouts.master')

@section('title')
    تعديل بيانات الدكتور
@endsection

@section('content')

    <div class="row">
        <div class="col-lg-12 offset-lg-2">

            <div class="card shadow-sm">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">تعديل بيانات الدكتور</h5>
                    <a href="{{ route('doctors.show', $doctor->id) }}" class="btn btn-sm btn-secondary">
                        رجوع لصفحة الدكتور
                    </a>
                </div>

                <div class="card-body">

                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <strong>خطأ!</strong> من فضلك تأكد من إدخال البيانات بشكل صحيح.
                            <ul class="mb-0 mt-2">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('doctors.update', $doctor->id) }}" method="POST">
                        @csrf
                        @method('PUT')

                        {{-- بيانات أساسية --}}
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">اسم الدكتور *</label>
                                <input type="text" name="name" class="form-control"
                                       value="{{ old('name', $doctor->name) }}" required>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label">البريد الإلكتروني *</label>
                                <input type="email" name="email" class="form-control"
                                       value="{{ old('email', $doctor->email) }}" required>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">الجوال</label>
                                <input type="text" name="phone" class="form-control"
                                       value="{{ old('phone', $doctor->phone) }}">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label">كلمة المرور الجديدة</label>
                                <input type="password" name="password" class="form-control"
                                       placeholder="اتركها فارغة للإبقاء على الحالية">
                            </div>
                        </div>

                        {{-- التخصص والحالة --}}
                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label class="form-label">التخصص *</label>
                                <select name="specialty_id" class="form-select" required>
                                    <option value="">اختر التخصص</option>
                                    @foreach($specialties as $specialty)
                                        <option value="{{ $specialty->id }}"
                                            {{ old('specialty_id', $doctor->doctorProfile?->specialty_id) == $specialty->id ? 'selected' : '' }}>
                                            {{ $specialty->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>


                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">العيادة</label>
                                <input type="text" class="form-control"
                                       value="{{ $doctor->clinic?->name ?? '-' }}" disabled>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">الفرع</label>
                                <input type="text" class="form-control"
                                       value="{{ $doctor->branch?->name ?? '-' }}" disabled>
                            </div>
                        </div>

                        <div class="d-flex justify-content-end mt-3">
                            <button type="submit" class="btn btn-success">
                                حفظ التعديلات
                            </button>
                        </div>

                    </form>

                </div>
            </div>

        </div>
    </div>

@endsection

@push('scripts')
    <script>
        const isActiveSwitch = document.getElementById('is_active_switch');
        const isActiveLabel  = document.querySelector('label[for="is_active_switch"]');

        if (isActiveSwitch && isActiveLabel) {
            isActiveSwitch.addEventListener('change', function () {
                if (this.checked) {
                    isActiveLabel.textContent = 'نشط';
                } else {
                    isActiveLabel.textContent = 'غير نشط';
                }
            });
        }
    </script>
@endpush
