@extends('admin.layouts.master')

@section('title')
    عرض بيانات الدكتور
@endsection
@section('content')

    @php
        $profile = $doctor->doctorProfile;
    @endphp

    <div class="row">
        {{-- الكارت الجانبي: بيانات الدكتور الأساسية --}}
        <div class="col-lg-4">
            <div class="card shadow-sm mb-4">
                <div class="card-body text-center">

                    {{-- Avatar بسيط باسم الدكتور --}}
                    <img src="https://ui-avatars.com/api/?name={{ urlencode($doctor->name) }}&size=150"
                         class="rounded-circle mb-3" alt="Doctor Avatar">

                    <h4>{{ $doctor->name }}</h4>

                    <p class="text-muted mb-1">
                        {{ $profile?->specialty?->name ?? 'بدون تخصص محدد' }}
                    </p>

                    <p class="mb-2">
                        <strong>العيادة:</strong>
                        {{ $doctor->clinic?->name ?? '-' }}<br>

                        <strong>الفرع:</strong>
                        {{ $doctor->branch?->name ?? '-' }}
                    </p>

                    <p class="mb-2">
                        <strong>الحالة:</strong>
                        @if($doctor->is_active)
                            <span class="badge bg-success">نشط</span>
                        @else
                            <span class="badge bg-danger">غير نشط</span>
                        @endif
                    </p>

                    <hr>

                    <p class="mb-2">
                        <strong>البريد:</strong> {{ $doctor->email }} <br>
                        <strong>الجوال:</strong> {{ $doctor->phone ?? '-' }}
                    </p>

                    <p class="text-muted mb-0">
                        <small>تاريخ التسجيل: {{ $doctor->created_at?->format('Y-m-d') }}</small>
                    </p>

                    <hr>

                    <a href="{{ route('doctors.edit', $doctor->id) }}"
                       class="btn btn-primary w-100">
                        تعديل بيانات الدكتور
                    </a>
                </div>
            </div>
        </div>

        {{-- الكروت الرئيسية: المواعيد / الزيارات / الخطط العلاجية / الروشتات --}}
        <div class="col-lg-8">

            {{-- مواعيد الطبيب --}}
            <div class="card shadow-sm mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">مواعيد الطبيب</h5>
                </div>
                <div class="card-body">
                    @if($profile && $profile->appointments->count())
                        <div class="table-responsive">
                            <table class="table table-sm table-striped align-middle">
                                <thead>
                                <tr>
                                    <th>#</th>
                                    <th>المريض</th>
                                    <th>التاريخ</th>
                                    <th>الوقت</th>
                                    <th>الحالة</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($profile->appointments->sortByDesc('appointment_date')->take(15) as $app)
                                    <tr>
                                        <td>{{ $app->id }}</td>
                                        <td>{{ $app->patient?->first_name  ?? '-' }}</td>
                                        <td>{{ $app->appointment_date }}</td>
                                        <td>{{ $app->start_time }}</td>
                                        <td>{{ $app->status }}</td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <p class="text-center text-muted mb-0">
                            لا توجد مواعيد مسجلة لهذا الطبيب.
                        </p>
                    @endif
                </div>
            </div>

            {{-- زيارات الطبيب --}}
            <div class="card shadow-sm mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">زيارات الطبيب</h5>
                </div>
                <div class="card-body">
                    @if($profile && $profile->visits->count())
                        <div class="table-responsive">
                            <table class="table table-sm table-striped align-middle">
                                <thead>
                                <tr>
                                    <th>#</th>
                                    <th>المريض</th>
                                    <th>تاريخ الزيارة</th>
                                    <th>الحالة</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($profile->visits->sortByDesc('visit_date')->take(5) as $visit)
                                    <tr>
                                        <td>{{ $visit->id }}</td>
                                        <td>{{ $visit->patient?->first_name ?? '-' }}</td>
                                        <td>{{ $visit->visit_date }}</td>
                                        <td>{{ $visit->status ?? '-' }}</td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <p class="text-center text-muted mb-0">
                            لا توجد زيارات مسجلة لهذا الطبيب.
                        </p>
                    @endif
                </div>
            </div>


            <div class="card shadow-sm mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">الروشتات المكتوبة</h5>
                </div>

                <div class="card-body">

                    @if($profile && $profile->prescriptions->count())

                        <div class="prescriptions-list">

                            @foreach($profile->prescriptions->sortByDesc('created_at')->take(15) as $rx)

                                <div class="card mb-3 shadow-sm">
                                    <div class="card-header d-flex justify-content-between align-items-center">

                                        <div>
                                            <strong>روشتة رقم #{{ $rx->id }}</strong><br>
                                            <small class="text-muted">
                                                {{ $rx->created_at->format('Y-m-d H:i') }}
                                                — للمريض: {{ $rx->patient?->name ?? '-' }}
                                            </small>
                                        </div>
                                        <div class="d-flex gap-1">
                                            <button class="btn btn-sm btn-outline-primary"
                                                    onclick="document.getElementById('rx-{{ $rx->id }}').classList.toggle('d-none')">
                                                عرض التفاصيل
                                            </button>

                                            <a href="{{ route('patients.prescriptions.print', $rx->id) }}"
                                               target="_blank"
                                               class="btn btn-sm btn-secondary">
                                                طباعة
                                            </a>
                                        </div>
                                    </div>

                                    <div class="card-body d-none" id="rx-{{ $rx->id }}">

                                        {{-- النص الكامل للروشتة --}}
                                        <div class="rx-text">
                                            {!! $rx->notes !!}
                                        </div>


                                    </div>
                                </div>

                            @endforeach

                        </div>

                    @else
                        <p class="text-center text-muted mb-0">
                            لا توجد روشتات مسجلة لهذا الطبيب.
                        </p>
                    @endif

                </div>
            </div>


        </div>
    </div>

@endsection
