@extends('admin.layouts.master')

@section('title', 'لوحة التحكم')

@section('css')
    {{-- CSS إضافي لو حابب --}}
@endsection

@section('content')

    <div class="row">
        <div class="col-12">

            {{-- كارت الترحيب --}}
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body bg-primary rounded-3">
                            <div class="row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <div class="d-lg-flex justify-content-between align-items-center ">
                                        <div class="d-md-flex align-items-center">
                                            <img src="{{ asset('dash/assets/images/user/avatar-2.jpg') }}" alt="Image"
                                                 class="rounded-circle avatar avatar-xl">
                                            <div class="mt-3 ms-md-4">
                                                <h2 class="mb-1 text-white fw-600">
                                                    أهلاً، {{ $user->name }}
                                                </h2>
                                                <p class="text-white mb-1">
                                                    عيادة: {{ $user->clinic?->name ?? '-' }}
                                                    @if($user->branch)
                                                        — فرع: {{ $user->branch->name }}
                                                    @endif
                                                </p>
                                                <small class="text-white-50">
                                                    نظرة سريعة على أداء المركز اليوم.
                                                </small>
                                            </div>
                                        </div>
                                        {{-- ممكن تضيف أزرار اختصارات هنا لو حابب --}}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            {{-- الكروت الإحصائية السريعة --}}
            <div class="row mt-2">

                <div class="col-xl-3 col-sm-6">
                    <div class="card">
                        <div class="border rounded card-body border-success bg-light-success">
                            <div class="d-flex align-items-center">
                                <div class="numbers flex-grow-1 pe-3">
                                    <p class="mb-1 fw-600 text-muted">إجمالي المرضى</p>
                                    <h4 class="mb-0 fw-700 text-dark-black">
                                        {{ $totalPatients }}
                                    </h4>
                                </div>
                                <div class="icon-shape bg-success ">
                                    <i class="ti ti-users"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-sm-6">
                    <div class="card">
                        <div class="border rounded card-body border-info bg-light">
                            <div class="d-flex align-items-center">
                                <div class="numbers flex-grow-1 pe-3">
                                    <p class="mb-1 fw-600 text-muted">مرضى جدد اليوم</p>
                                    <h4 class="mb-0 fw-700 text-dark-black">
                                        {{ $newPatientsToday }}
                                    </h4>
                                </div>
                                <div class="icon-shape bg-info ">
                                    <i class="ti ti-user-plus"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-sm-6">
                    <div class="card">
                        <div class="border rounded card-body border-warning bg-light-warning">
                            <div class="d-flex align-items-center">
                                <div class="numbers flex-grow-1 pe-3">
                                    <p class="mb-1 fw-600 text-muted">مواعيد اليوم</p>
                                    <h4 class="mb-0 fw-700 text-dark-black">
                                        {{ $todayAppointments }}
                                    </h4>
                                </div>
                                <div class="icon-shape bg-warning ">
                                    <i class="ti ti-calendar"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-sm-6">
                    <div class="card">
                        <div class="border rounded card-body border-primary bg-light-primary">
                            <div class="d-flex align-items-center">
                                <div class="numbers flex-grow-1">
                                    <p class="mb-1 fw-600 text-muted">فواتير الشهر الحالي</p>
                                    <h4 class="mb-0 fw-700 text-dark-black">
                                        {{ number_format($monthInvoicesTotal, 2) }}
                                        <span class="text-sm text-muted"><img src="{{asset('dash/Saudi_Riyal_Symbol.svg.png')}}" width="20px" height="20px" alt=""></span>
                                    </h4>
                                </div>
                                <div class="icon-shape bg-primary ">
                                    <i class="ti ti-report-money"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>


            {{-- كروت إضافية (اختياري) --}}
            <div class="row mt-2">

                <div class="col-xl-3 col-sm-6">
                    <div class="card">
                        <div class="border rounded card-body border-secondary bg-light">
                            <div class="d-flex align-items-center">
                                <div class="numbers flex-grow-1 pe-3">
                                    <p class="mb-1 fw-600 text-muted">زيارات اليوم المكتملة</p>
                                    <h4 class="mb-0 fw-700 text-dark-black">
                                        {{ $todayVisits }}
                                    </h4>
                                </div>
                                <div class="icon-shape bg-secondary ">
                                    <i class="ti ti-stethoscope"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-sm-6">
                    <div class="card">
                        <div class="border rounded card-body border-success bg-light">
                            <div class="d-flex align-items-center">
                                <div class="numbers flex-grow-1 pe-3">
                                    <p class="mb-1 fw-600 text-muted">الأطباء النشطين</p>
                                    <h4 class="mb-0 fw-700 text-dark-black">
                                        {{ $activeDoctors }}
                                    </h4>
                                </div>
                                <div class="icon-shape bg-success ">
                                    <i class="fa fa-user-friends"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>


            {{-- الجرافات --}}
            <div class="row mt-3">

                {{-- المواعيد خلال آخر 7 أيام --}}
                <div class="col-xxl-4 col-lg-6 col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="mb-0">المواعيد خلال آخر 7 أيام</h4>
                        </div>
                        <div class="card-body">
                            <div id="appointments-chart" style="min-height: 280px;"></div>
                        </div>
                    </div>
                </div>

                {{-- إحصائيات المواعيد حسب الحالة --}}
                <div class="col-xxl-8 col-lg-6 col-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h4 class="mb-0">إحصائيات المواعيد حسب الحالة</h4>
                        </div>
                        <div class="card-body">
                            <div id="appointments-status-chart" style="min-height: 280px;"></div>
                        </div>
                    </div>
                </div>

            </div>


            {{-- جدول أحدث المواعيد --}}
            <div class="row mt-3">
                <div class="col-12">
                    <div class="card table-card">
                        <div class="card-header">
                            <h4>أحدث المواعيد</h4>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>المريض</th>
                                        <th>الدكتور</th>
                                        <th>التاريخ</th>
                                        <th>الوقت</th>
                                        <th>الحالة</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @forelse($latestAppointments as $app)
                                        <tr>
                                            <td>{{ $app->id }}</td>
                                            <td>{{ $app->patient?->first_name ?? $app->patient?->name ?? '-' }}</td>
                                            <td>{{ $app->doctor?->user?->name ?? '-' }}</td>
                                            <td>{{ $app->appointment_date->format('Y-m-d') }}</td>
                                            <td>{{ \Carbon\Carbon::parse($app->start_time)->format('h:i A') }}</td>

                                            <td>
                                                @php
                                                    $status = $app->status;
                                                    $badgeClass = match ($status) {
                                                        'confirmed' => 'success',
                                                        'pending'   => 'warning',
                                                        'cancelled' => 'danger',
                                                        default     => 'secondary',
                                                    };
                                                @endphp
                                                <span class="badge bg-{{ $badgeClass }}">
                                                    {{ $status }}
                                                </span>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="6" class="text-center text-muted">
                                                لا توجد مواعيد مسجلة.
                                            </td>
                                        </tr>
                                    @endforelse
                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>
                </div>
            </div>


        </div>
    </div>

@endsection

@section('js')
    <script>
        document.addEventListener('DOMContentLoaded', function () {

            // نتأكد إن ApexCharts متحمّل (من layout أو من ملف JS عام)
            if (typeof ApexCharts === 'undefined') {
                console.warn('ApexCharts not loaded');
                return;
            }



            const appointmentsData = @json($appointmentsLast7Days ?? []);
            const appDates  = appointmentsData.map(item => item.date);
            const appCounts = appointmentsData.map(item => item.count);

            const appointmentsEl = document.querySelector('#appointments-chart');
            if (appointmentsEl) {
                const appointmentsOptions = {
                    chart: {
                        type: 'area',
                        height: 280,
                        toolbar: {show: false},
                        fontFamily: 'Cairo, sans-serif'
                    },
                    dataLabels: {enabled: false},
                    stroke: {
                        curve: 'smooth',
                        width: 3
                    },
                    series: [{
                        name: 'عدد المواعيد',
                        data: appCounts
                    }],
                    xaxis: {
                        categories: appDates,
                        labels: {
                            style: { fontFamily: 'Cairo, sans-serif' }
                        }
                    },
                    yaxis: {
                        labels: {
                            style: { fontFamily: 'Cairo, sans-serif' }
                        }
                    },
                    fill: {
                        opacity: 0.4
                    },
                    tooltip: {
                        y: { formatter: val => val + ' موعد' }
                    }
                };

                const appointmentsChart = new ApexCharts(appointmentsEl, appointmentsOptions);
                appointmentsChart.render();
            }


            const statusData   = @json($appointmentsByStatus ?? []);
            const statusMap    = {
                'confirmed': 'مؤكد',
                'pending'  : 'قيد التأكيد',
                'cancelled': 'ملغى'
            };

            const statusLabels = statusData.map(item => statusMap[item.status] ?? item.status);
            const statusCounts = statusData.map(item => item.count);

            const statusEl = document.querySelector('#appointments-status-chart');
            if (statusEl) {
                const statusOptions = {
                    chart: {
                        type: 'pie',
                        height: 280,
                        fontFamily: 'Cairo, sans-serif'
                    },
                    labels: statusLabels,
                    series: statusCounts,
                    legend: {
                        position: 'bottom',
                        fontFamily: 'Cairo, sans-serif'
                    },
                    tooltip: {
                        y: { formatter: val => val + ' موعد' }
                    }
                };

                const statusChart = new ApexCharts(statusEl, statusOptions);
                statusChart.render();
            }

        });
    </script>
@endsection
