@extends('admin.layouts.master')

@section('title')
    {{ $item->exists ? 'تعديل صنف بالمخزون' : 'إضافة صنف جديد للمخزون' }}
@endsection

@section('content')

    <div class="content-header d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0">
            {{ $item->exists ? 'تعديل صنف بالمخزون' : 'إضافة صنف جديد للمخزون' }}
        </h5>

        <a href="{{ route('inventory.items.index') }}" class="btn btn-sm btn-outline-secondary">
            رجوع لقائمة المخزون
        </a>
    </div>

    @if($errors->any())
        <div class="alert alert-danger">
            <strong>من فضلك صحح الأخطاء التالية:</strong>
            <ul class="mb-0">
                @foreach($errors->all() as $err)
                    <li>{{ $err }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ $item->exists
        ? route('inventory.items.update', $item->id)
        : route('inventory.items.store') }}"
          method="POST">
        @csrf
        @if($item->exists)
            @method('PUT')
        @endif

        <div class="card">
            <div class="card-header">
                <h6 class="mb-0">بيانات الصنف</h6>
            </div>

            <div class="card-body">
                <div class="row g-3">

                    <div class="col-md-4">
                        <label class="form-label">اسم الصنف *</label>
                        <input type="text"
                               name="name"
                               class="form-control"
                               required
                               value="{{ old('name', $item->name) }}">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">التصنيف</label>
                        <select name="category" class="form-select">
                            @php
                                $category = old('category', $item->category);
                            @endphp
                            <option value="">بدون</option>
                            <option value="consumable" {{ $category == 'consumable' ? 'selected' : '' }}>مستهلكات</option>
                            <option value="equipment"  {{ $category == 'equipment'  ? 'selected' : '' }}>معدات</option>
                            <option value="medication" {{ $category == 'medication' ? 'selected' : '' }}>أدوية</option>
                            <option value="other"      {{ $category == 'other'      ? 'selected' : '' }}>أخرى</option>
                        </select>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">الوحدة</label>
                        <input type="text"
                               name="unit"
                               class="form-control"
                               placeholder="مثال: علبة، قطعة، مل، جرام..."
                               value="{{ old('unit', $item->unit) }}">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">SKU / الكود الداخلي</label>
                        <input type="text"
                               name="sku"
                               class="form-control"
                               value="{{ old('sku', $item->sku) }}">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">الحد الأدنى للكمية *</label>
                        <input type="number" min="0"
                               name="min_quantity"
                               class="form-control"
                               value="{{ old('min_quantity', $item->min_quantity ?? 0) }}">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">الكمية الحالية *</label>
                        <input type="number" min="0"
                               name="current_quantity"
                               class="form-control"
                               value="{{ old('current_quantity', $item->current_quantity ?? 0) }}">
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">سعر الشراء للوحدة *</label>
                        <div class="input-group">
                            <input type="number" min="0" step="0.01"
                                   name="purchase_price"
                                   class="form-control"
                                   value="{{ old('purchase_price', $item->purchase_price ?? 0) }}">
                            <span class="input-group-text">
                                <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="16" height="16" alt="">
                            </span>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">سعر البيع (اختياري)</label>
                        <div class="input-group">
                            <input type="number" min="0" step="0.01"
                                   name="sale_price"
                                   class="form-control"
                                   value="{{ old('sale_price', $item->sale_price ?? 0) }}">
                            <span class="input-group-text">
                                <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="16" height="16" alt="">
                            </span>
                        </div>
                    </div>

                </div>
            </div>

            <div class="card-footer text-end">
                <button type="submit" class="btn btn-primary">
                    {{ $item->exists ? 'تحديث بيانات الصنف' : 'حفظ الصنف في المخزون' }}
                </button>
            </div>
        </div>
    </form>

@endsection
