@extends('admin.layouts.master')

@section('title', 'مخزون العيادة')

@section('content')

    <div class="content-header d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0">مخزون العيادة</h5>

        <a href="{{ route('inventory.items.create') }}" class="btn btn-sm btn-success">
            إضافة صنف جديد
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    {{-- كروت إحصائيات بسيطة --}}
    <div class="row mb-3">
        <div class="col-md-4">
            <div class="card border-primary">
                <div class="card-body">
                    <h6 class="text-muted mb-1">إجمالي عدد الأصناف</h6>
                    <h4 class="mb-0 fw-bold">{{ $totalItemsCount }}</h4>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card border-danger">
                <div class="card-body">
                    <h6 class="text-muted mb-1">أصناف أقل من الحد الأدنى</h6>
                    <h4 class="mb-0 fw-bold text-danger">{{ $lowStockCount }}</h4>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card border-success">
                <div class="card-body">
                    <h6 class="text-muted mb-1">قيمة المخزون (تقريبية)</h6>
                    <h4 class="mb-0 fw-bold">
                        {{ number_format($totalStockValue, 2) }}
                        <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="18" height="18" alt="">
                    </h4>
                </div>
            </div>
        </div>
    </div>

    {{-- جدول الأصناف --}}
    <div class="card table-card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h6 class="mb-0">قائمة الأصناف</h6>
        </div>

        <div class="card-body">
            @if($items->count())
                <div class="table-responsive">
                    <table class="table table-striped align-middle">
                        <thead>
                        <tr>
                            <th>#</th>
                            <th>اسم الصنف</th>
                            <th>التصنيف</th>
                            <th>الوحدة</th>
                            <th>الحد الأدنى</th>
                            <th>الكمية الحالية</th>
                            <th>سعر الشراء</th>
                            <th>سعر البيع</th>
                            <th>حالة المخزون</th>
                            <th>إجراءات</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($items as $item)
                            @php
                                $isLow = $item->current_quantity < $item->min_quantity;
                            @endphp
                            <tr>
                                <td>{{ $item->id }}</td>
                                <td>{{ $item->name }}</td>
                                <td>{{ $item->category ?: '-' }}</td>
                                <td>{{ $item->unit ?: '-' }}</td>
                                <td>{{ $item->min_quantity }}</td>
                                <td>{{ $item->current_quantity }}</td>
                                <td>
                                    {{ number_format($item->purchase_price, 2) }}
                                    <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="14" height="14" alt="">
                                </td>
                                <td>
                                    @if($item->sale_price > 0)
                                        {{ number_format($item->sale_price, 2) }}
                                        <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="14" height="14" alt="">
                                    @else
                                        -
                                    @endif
                                </td>
                                <td>
                                    @if($isLow)
                                        <span class="badge bg-danger">أقل من الحد الأدنى</span>
                                    @else
                                        <span class="badge bg-success">مخزون كافي</span>
                                    @endif
                                </td>
                                <td>

                                    {{-- زر زيادة المخزون --}}
                                    <button type="button"
                                            class="btn btn-sm btn-success"
                                            onclick="openStockModal({{ $item->id }}, '{{ $item->name }}', 'in')">
                                        + زيادة
                                    </button>

                                    {{-- زر نقصان المخزون --}}
                                    <button type="button"
                                            class="btn btn-sm btn-warning"
                                            onclick="openStockModal({{ $item->id }}, '{{ $item->name }}', 'out')">
                                        - نقصان
                                    </button>
                                    @include('admin.inventory.model')

                                    <a href="{{ route('inventory.items.edit', $item->id) }}"
                                       class="btn btn-sm btn-primary">
                                        تعديل
                                    </a>

                                    <form action="{{ route('inventory.items.destroy', $item->id) }}"
                                          method="POST"
                                          class="d-inline"
                                          onsubmit="return confirm('هل تريد حذف هذا الصنف من المخزون؟');">
                                        @csrf
                                        @method('DELETE')
                                        <button class="btn btn-sm btn-danger">حذف</button>
                                    </form>

                                </td>

                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>

                <div class="mt-3">
                    {{ $items->links() }}
                </div>
            @else
                <p class="text-center text-muted mb-0">
                    لا توجد أصناف في المخزون حتى الآن.
                </p>
            @endif
        </div>
    </div>

@endsection

@section('js')
    <script>
        function openStockModal(itemId, itemName, type) {
            let title = (type === 'in')
                ? 'زيادة مخزون: ' + itemName
                : 'نقصان مخزون: ' + itemName;

            document.getElementById('stockModalTitle').innerText = title;
            document.getElementById('stockType').value = type;

            let form = document.getElementById('stockForm');
            form.action = "/inventory/items/" + itemId + "/movement";

            new bootstrap.Modal(document.getElementById('stockModal')).show();
        }
    </script>
@endsection

