@extends('admin.layouts.master')

@section('title', 'الفواتير')

@section('content')

    <div class="content-header d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0">كل الفواتير</h5>
        <a href="{{ route('invoices.create') }}" class="btn btn-sm btn-primary">
            إضافة فاتورة جديدة
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <div class="card table-card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table" id="pc-dt-simple">
                    <thead>
                    <tr>
                        <th class="text-start">#</th>
                        <th class="text-start">رقم الفاتورة</th>
                        <th class="text-start">تاريخ الفاتورة</th>
                        <th class="text-start">المريض</th>
                        <th class="text-start">العيادة / الفرع</th>
                        <th class="text-start">الإجمالي</th>
                        <th class="text-start">المدفوع</th>
                        <th class="text-start">الحالة</th>
                        <th class="text-start">إجراءات</th>
                    </tr>
                    </thead>
                    <tbody>
                    @php $i = ($invoices->currentPage() - 1) * $invoices->perPage() + 1; @endphp
                    @forelse($invoices as $invoice)
                        @php
                            $statusBadgeClass = match($invoice->status) {
                                'paid'     => 'badge bg-success',
                                'partial'  => 'badge bg-warning',
                                'refunded' => 'badge bg-info',
                                default    => 'badge bg-danger',
                            };
                            $statusText = match($invoice->status) {
                                'paid'     => 'مدفوعة',
                                'partial'  => 'مدفوعة جزئياً',
                                'refunded' => 'مستردة',
                                default    => 'غير مدفوعة',
                            };
                        @endphp
                        <tr>
                            <td>{{ $i++ }}</td>
                            <td>{{ $invoice->invoice_number }}</td>
                            <td>{{ $invoice->date?->format('Y-m-d') }}</td>
                            <td>
                                {{ $invoice->patient?->first_name }} {{ $invoice->patient?->last_name }}
                                @if($invoice->patient?->code)
                                    <br>
                                    <small class="text-muted">({{ $invoice->patient->code }})</small>
                                @endif
                            </td>
                            <td>
                                {{ $invoice->clinic?->name ?? '-' }}
                                @if($invoice->branch)
                                    <br><small class="text-muted">فرع: {{ $invoice->branch->name }}</small>
                                @endif
                            </td>
                            <td>
                                {{ number_format($invoice->total, 2) }}
                                <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="14" height="14" alt="ر.س">
                            </td>
                            <td>
                                {{ number_format($invoice->paid_amount, 2) }}
                                <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="14" height="14" alt="ر.س">
                            </td>
                            <td>
                                <span class="{{ $statusBadgeClass }}">{{ $statusText }}</span>
                            </td>
                            <td>
                                <a href="{{ route('invoices.show', $invoice->id) }}"
                                   class="btn btn-sm btn-outline-primary">
                                    عرض
                                </a>

                                <a href="{{ route('invoices.edit', $invoice->id) }}"
                                   class="btn btn-sm btn-outline-primary">تعديل</a>

                                <a href="{{ route('invoices.invoices_print', $invoice->id) }}"
                                   target="_blank"
                                   class="btn btn-sm btn-outline-secondary">
                                    طباعة
                                </a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="9" class="text-center text-muted">
                                لا توجد فواتير مسجلة حتى الآن.
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-3">
                {{ $invoices->links() }}
            </div>
        </div>
    </div>

@endsection
