@extends('admin.layouts.master')

@section('title', 'خطط العلاج')

@section('content')

    <div class="content-header mb-3">
        <div class="d-flex justify-content-between align-items-center">
            <h5 class="mb-0">خطط العلاج</h5>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if(session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif

    <div class="row">
        <div class="col-12">
            <div class="card table-card">
                <div class="card-header">
                    <h6 class="mb-0">قائمة خطط العلاج</h6>
                </div>
                <div class="card-body">

                    <div class="table-responsive">
                        <table class="table" id="pc-dt-simple">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>المريض</th>
                                <th>الطبيب</th>
                                <th>العنوان</th>
                                <th>الحالة</th>
                                <th>تاريخ الإنشاء</th>
                                <th class="text-center">إجراءات</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse($plans as $plan)
                                @php
                                    $status = $plan->status;
                                    $badgeClass = match($status) {
                                        'draft'    => 'secondary',
                                        'ongoing'  => 'warning',
                                        'completed'=> 'success',
                                        'cancelled'=> 'danger',
                                        default    => 'secondary',
                                    };
                                @endphp
                                <tr>
                                    <td>{{ $plan->id }}</td>
                                    <td>
                                        {{ $plan->patient?->first_name }} {{ $plan->patient?->last_name }}
                                        <br>
                                        <small class="text-muted">كود: {{ $plan->patient?->code ?? '-' }}</small>
                                    </td>
                                    <td>
                                        {{ $plan->doctor?->user?->name ?? '-' }}
                                    </td>
                                    <td>{{ $plan->title ?? '-' }}</td>
                                    <td>
                                        <span class="badge bg-{{ $badgeClass }}">
                                            @switch($status)
                                                @case('draft') مسودة @break
                                                @case('ongoing') جارية @break
                                                @case('completed') مكتملة @break
                                                @case('cancelled') ملغاة @break
                                                @default غير معروف
                                            @endswitch
                                        </span>
                                    </td>
                                    <td>{{ $plan->created_at?->format('Y-m-d') }}</td>
                                    <td class="text-center">
                                        <div class="btn-group btn-sm btn-group-sm" role="group">
                                            <a href="{{ route('treatment-plans.show', $plan->id) }}"
                                               class="btn btn-primary">
                                                عرض
                                            </a>

{{--                                            <form action="{{ route('treatment-plans.destroy', $plan->id) }}"--}}
{{--                                                  method="POST"--}}
{{--                                                  onsubmit="return confirm('هل أنت متأكد من حذف هذه الخطة؟');">--}}
{{--                                                @csrf--}}
{{--                                                @method('DELETE')--}}
{{--                                                <button type="submit" class="btn btn-sm btn-danger">--}}
{{--                                                    حذف--}}
{{--                                                </button>--}}
{{--                                            </form>--}}
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="text-center text-muted">
                                        لا توجد خطط علاج مسجلة حتى الآن.
                                    </td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3">
                        {{ $plans->links() }}
                    </div>

                </div>
            </div>
        </div>
    </div>

@endsection
