@extends('admin.layouts.master')

@section('title', 'خطة علاج رقم '.$plan->id)

@section('content')

    <div class="content-header mb-3">
        <div class="d-flex justify-content-between align-items-center">
            <h5 class="mb-0">
                خطة علاج للمريض: {{ $plan->patient?->first_name }} {{ $plan->patient?->last_name }}
            </h5>

            <div class="d-flex gap-2">
                <a href="{{ route('patients.show', $plan->patient_id) }}" class="btn btn-sm btn-secondary">
                    رجوع لملف المريض
                </a>

                <form action="{{ route('treatment-plans.destroy', $plan->id) }}"
                      method="POST"
                      onsubmit="return confirm('هل تريد حذف هذه الخطة؟');">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-sm btn-danger">حذف الخطة</button>
                </form>
            </div>
        </div>
    </div>


    @if($errors->any())
        <div class="alert alert-danger">
            من فضلك صحح الأخطاء التالية:
            <ul class="mb-0">
                @foreach($errors->all() as $err)
                    <li>{{ $err }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    @php
        $total = 0;
        foreach ($plan->items as $it) {
            $line = ($it->price - $it->discount) * $it->quantity;
            $total += max($line, 0);
        }
    @endphp

    <div class="row gy-3">

        <div class="col-lg-4 col-12">
            <div class="card h-100">
                <div class="card-header">
                    <h6 class="mb-0">بيانات خطة العلاج</h6>
                </div>
                <div class="card-body">

                    <p class="mb-2"><strong>المريض:</strong>
                        {{ $plan->patient?->first_name }} {{ $plan->patient?->last_name }}
                        <br>
                        <small class="text-muted">كود: {{ $plan->patient?->code ?? '-' }}</small>
                    </p>

                    <p class="mb-2"><strong>الطبيب:</strong>
                        {{ $plan->doctor?->user?->name ?? '-' }}
                    </p>

                    <span><strong>السن:</strong>
                        @if($plan->patient?->birth_date)
                            {{ \Carbon\Carbon::parse($plan->patient->birth_date)->age }} سنة
                        @else
                            —
                        @endif
                    </span>

                    <p class="mb-2"><strong>العنوان:</strong> {{ $plan->title ?: '-' }}</p>

                    <p class="mb-2"><strong>الحالة:</strong></p>

                    <form action="{{ route('treatment-plans.update-status', $plan->id) }}"
                          method="POST" class="d-flex align-items-center gap-2 mb-3">
                        @csrf
                        @method('PATCH')

                        <select name="status" class="form-select form-select-sm" style="max-width: 180px;">
                            <option value="draft" {{ $plan->status == 'draft' ? 'selected' : '' }}>مسودة</option>
                            <option value="ongoing" {{ $plan->status == 'ongoing' ? 'selected' : '' }}>جارية</option>
                            <option value="completed" {{ $plan->status == 'completed' ? 'selected' : '' }}>مكتملة
                            </option>
                            <option value="cancelled" {{ $plan->status == 'cancelled' ? 'selected' : '' }}>ملغاة
                            </option>
                        </select>

                        <button type="submit" class="btn btn-sm btn-outline-primary">
                            حفظ
                        </button>
                    </form>


                    <p class="mb-2"><strong>إجمالي تقديري:</strong>
                        {{ number_format($total, 2) }}
                        <small class="text-muted">ريال</small>
                    </p>

                    <p class="mb-0"><strong>ملاحظات الخطة:</strong><br>
                        {{ $plan->description ?: '-' }}
                    </p>

                </div>
            </div>
        </div>

        {{-- بنود الخطة + إضافة بند جديد --}}
        <div class="col-lg-8 col-12">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">بنود خطة العلاج</h6>
                </div>
                <div class="card-body">

                    <form action="{{ route('treatment-plans.items.store', $plan->id) }}" method="POST" class="mb-3">
                        @csrf

                        <div class="row g-2 align-items-end">

                            <div class="col-md-4">
                                <label class="form-label">الخدمة</label>
                                <select name="service_id" class="form-select">
                                    <option value="">اختر خدمة (اختياري)</option>
                                    @foreach($services as $service)
                                        <option value="{{ $service->id }}"
                                                data-price="{{ $service->default_price }}"
                                            {{ old('service_id') == $service->id ? 'selected' : '' }}>
                                            {{ $service->name }} - {{ number_format($service->default_price, 2) }}
                                        </option>

                                    @endforeach
                                </select>
                            </div>

                            <div class="col-md-2">
                                <label class="form-label">السن</label>
                                <input type="text" name="tooth_number"
                                       class="form-control"
                                       value="{{ $plan->patient?->birth_date != null ? \Carbon\Carbon::parse($plan->patient->birth_date)->age : "" }}"
                                >
                            </div>

                            <div class="col-md-2">
                                <label class="form-label">السطح</label>
                                <input type="text" name="surface"
                                       class="form-control"
                                       value="{{ old('surface') }}"
                                       placeholder="MO, DO...">
                            </div>

                            <div class="col-md-2">
                                <label class="form-label">العدد</label>
                                <input type="number" name="quantity" min="1"
                                       class="form-control"
                                       value="{{ old('quantity', 1) }}" required>
                            </div>

                            <div class="col-md-2">
                                <label class="form-label">السعر</label>
                                <input type="number" step="0.01" min="0"
                                       name="price" class="form-control"
                                       value="{{ old('price', 0) }}" readonly>
                            </div>

                            <div class="col-md-2 mt-2">
                                <label class="form-label">الخصم</label>
                                <input type="number" step="0.01" min="0"
                                       name="discount" class="form-control"
                                       value="{{ old('discount', 0) }}">
                            </div>

                            <div class="col-md-3 mt-2">
                                <label class="form-label">الحالة</label>
                                <select name="status" class="form-select" required>
                                    <option value="planned" {{ old('status') == 'planned' ? 'selected' : '' }}>
                                        مخطط
                                    </option>
                                    <option value="in_progress" {{ old('status') == 'in_progress' ? 'selected' : '' }}>
                                        جاري
                                    </option>
                                    <option value="done" {{ old('status') == 'done' ? 'selected' : '' }}>
                                        تم التنفيذ
                                    </option>
                                    <option value="cancelled" {{ old('status') == 'cancelled' ? 'selected' : '' }}>
                                        ملغي
                                    </option>
                                </select>
                            </div>

                            <div class="col-md-7 mt-2">
                                <label class="form-label">ملاحظات / تفاصيل البند</label>
                                <input type="text" name="notes"
                                       class="form-control"
                                       value="{{ old('notes') }}"
                                       placeholder="مثال: حشو عصب الضرس السادس علوي يمين...">
                            </div>

                        </div>

                        <button type="submit" class="btn btn-sm btn-primary mt-3">
                            إضافة البند إلى الخطة
                        </button>
                    </form>

                    @php
                        $subtotal = 0;
                        $totalDiscount = 0;
                        $grandTotal = 0;

                        foreach ($plan->items as $item) {

                            $lineBase = $item->price * $item->quantity;


                            $discountAmount = $item->discount ?? 0;


                            if ($discountAmount > $lineBase) {
                                $discountAmount = $lineBase;
                            }

                            $lineTotal = $lineBase - $discountAmount;

                            $subtotal      += $lineBase;
                            $totalDiscount += $discountAmount;
                            $grandTotal    += $lineTotal;
                        }
                    @endphp


                    {{-- جدول البنود --}}
                    <div class="table-responsive">
                        <table class="table table-sm table-striped align-middle">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>الخدمة</th>
                                <th>السن / السطح</th>
                                <th>العدد</th>
                                <th>السعر</th>
                                <th>الخصم</th>
                                <th>الإجمالي</th>
                                <th>الحالة</th>
                                <th>الزيارة</th>
                                <th class="text-center">إجراءات</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse($plan->items as $item)
                                @php
                                    $lineBase = $item->price * $item->quantity;
                                    $discountAmount = $item->discount ?? 0;

                                    if ($discountAmount > $lineBase) {
                                        $discountAmount = $lineBase;
                                    }

                                    $lineTotal = $lineBase - $discountAmount;

                                    $st = $item->status;
                                    $b = match($st) {
                                        'planned'     => 'secondary',
                                        'in_progress' => 'warning',
                                        'done'        => 'success',
                                        'cancelled'   => 'danger',
                                        default       => 'secondary',
                                    };
                                @endphp
                                <tr>
                                    <td>{{ $item->id }}</td>

                                    <td>
                                        @if($item->service)
                                            {{ $item->service->name }}
                                        @else
                                            <span class="text-muted">—</span>
                                        @endif
                                        @if($item->notes)
                                            <br>
                                            <small class="text-muted">{{ $item->notes }}</small>
                                        @endif
                                    </td>

                                    <td>
                                        {{ $item->tooth_number ?: '-' }}<br>
                                        <small class="text-muted">{{ $item->surface ?: '' }}</small>
                                    </td>

                                     <td>{{ $item->quantity }}</td>

                                    <td>
                                        {{ number_format($item->price, 2) }}
                                        <small class="text-muted">
                                            <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="12" height="12" alt="">
                                        </small>
                                    </td>

                                    <td>
                                        {{ number_format($discountAmount, 2) }}
                                        <small class="text-muted">
                                            <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="12" height="12" alt="">
                                        </small>
                                    </td>

                                    <td>
                                        {{ number_format($lineTotal, 2) }}
                                        <small class="text-muted">
                                            <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="12" height="12" alt="">
                                        </small>
                                    </td>


                                    <td>
                                        <form action="{{ route('treatment-plans.items.update-status', $item->id) }}"
                                              method="POST" class="d-flex align-items-center gap-1">
                                            @csrf
                                            @method('PATCH')

                                            <select name="status" class="form-select form-select-sm">
                                                <option value="planned" {{ $item->status == 'planned' ? 'selected' : '' }}>مخطط</option>
                                                <option value="in_progress" {{ $item->status == 'in_progress' ? 'selected' : '' }}>جاري</option>
                                                <option value="done" {{ $item->status == 'done' ? 'selected' : '' }}>تم</option>
                                                <option value="cancelled" {{ $item->status == 'cancelled' ? 'selected' : '' }}>ملغي</option>
                                            </select>

                                            <button type="submit" class="btn btn-sm btn-outline-primary">
                                                ✔
                                            </button>
                                        </form>
                                    </td>


                                    <td>
                                        @if($item->visit)
                                            زيارة رقم {{ $item->visit->id }}<br>
                                            <small class="text-muted">{{ $item->visit->visit_date ?? '' }}</small>
                                        @else
                                            —
                                        @endif
                                    </td>

                                    <td class="text-center">
                                        <form action="{{ route('treatment-plans.items.destroy', $item->id) }}"
                                              method="POST"
                                              onsubmit="return confirm('حذف هذا البند من الخطة؟');">
                                            @csrf
                                            @method('DELETE')
                                            <button class="btn btn-sm btn-danger">حذف</button>
                                        </form>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="10" class="text-center text-muted">لا توجد بنود مضافة لهذه الخطة بعد.
                                    </td>
                                </tr>
                            @endforelse

                            </tbody>
                            <tfoot>
                            <tr>
                                <th colspan="6" class="text-end">الإجمالي قبل الخصم</th>
                                <th colspan="4">
                                    {{ number_format($subtotal, 2) }}
                                    <small class="text-muted">
                                        <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="20" height="20" alt="">
                                    </small>
                                </th>
                            </tr>

                            <tr>
                                <th colspan="6" class="text-end">إجمالي الخصومات</th>
                                <th colspan="4">
                                    {{ number_format($totalDiscount, 2) }}
                                    <small class="text-muted">
                                        <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="20" height="20" alt="">
                                    </small>
                                </th>
                            </tr>

                            <tr class="table-success">
                                <th colspan="6" class="text-end fw-bold fs-5">الإجمالي النهائي</th>
                                <th colspan="4" class="fw-bold fs-5">
                                    {{ number_format($grandTotal, 2) }}
                                    <small class="text-muted">
                                        <img src="{{ asset('dash/Saudi_Riyal_Symbol.svg.png') }}" width="20" height="20" alt="">
                                    </small>
                                </th>
                            </tr>
                            </tfoot>


                        </table>
                    </div>

                </div>
            </div>
        </div>

    </div>

@endsection

@section('js')
    <script>
        document.addEventListener("DOMContentLoaded", function () {

            const serviceSelect = document.querySelector("select[name='service_id']");
            const priceInput = document.querySelector("input[name='price']");

            serviceSelect.addEventListener("change", function () {
                let selectedOption = this.options[this.selectedIndex];

                let price = selectedOption.getAttribute("data-price");

                if (!price) {
                    priceInput.value = 0;
                    return;
                }

                priceInput.value = price;
            });

        });
    </script>

@endsection
