@extends('admin.layouts.master')

@section('title', 'تعديل مستخدم')

@section('content')

<div class="content-header d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0">تعديل المستخدم: {{ $user->name }}</h5>

    <a href="{{ route('settings.users.index') }}" class="btn btn-sm btn-secondary">
        رجوع لقائمة المستخدمين
    </a>
</div>

@if(session('success'))
<div class="alert alert-success">{{ session('success') }}</div>
@endif

@if($errors->any())
<div class="alert alert-danger">
    <strong>من فضلك صحح الأخطاء التالية:</strong>
    <ul class="mb-0">
        @foreach($errors->all() as $err)
        <li>{{ $err }}</li>
        @endforeach
    </ul>
</div>
@endif

<form action="{{ route('settings.users.update', $user->id) }}" method="POST">
    @csrf
    @method('PUT')

    <div class="card">
        <div class="card-body">

            <div class="row g-3">

                <div class="col-md-4">
                    <label class="form-label">الاسم *</label>
                    <input type="text" name="name" class="form-control" value="{{$user->name}}" required>
                </div>

                <div class="col-md-4">
                    <label class="form-label">البريد *</label>
                    <input type="email" name="email" class="form-control" value="{{$user->email}}" required>
                </div>

                <div class="col-md-4">
                    <label class="form-label">الهاتف</label>
                    <input type="text" name="phone" value="{{$user->phone}}" class="form-control">
                </div>

                <div class="col-md-4">
                    <label class="form-label">الفرع</label>
                    <select name="branch_id" class="form-select">
                        <option value="">اختر فرع</option>
                        @foreach($branches as $b)
                            <option value="{{ $b->id  }}" {{$b->id == $user->branch_id ? 'selected' : null}}>{{ $b->name }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-4">
                    <label class="form-label">نوع المستخدم *</label>
                    <select name="role" class="form-select" required>
                        <option value="owner" {{$user->role == "owner" ? 'selected': null}}>Owner</option>
                        <option value="admin" {{$user->role == "admin" ? 'selected': null}}>Admin</option>
                        <option value="doctor" {{$user->role == "doctor" ? 'selected': null}}>Doctor</option>
                        <option value="receptionist" {{$user->role == "receptionist" ? 'selected': null}}>Receptionist</option>
                        <option value="accountant" {{$user->role == "accountant" ? 'selected': null}}>Accountant</option>
                        <option value="nurse" {{$user->role == "nurse" ? 'selected': null}}>Nurse</option>
                    </select>
                </div>

                <div class="col-md-4">
                    <label class="form-label">كلمة المرور *</label>
                    <input type="password" name="password" class="form-control" >
                </div>

            </div>

        </div>
        <div class="card-footer text-end">
            <button class="btn btn-primary">حفظ</button>
        </div>
    </div>


</form>

@endsection

@section('js')
<script>
    document.getElementById('btn-select-all').addEventListener('click', function () {
        document.querySelectorAll('.permission-checkbox').forEach(function (cb) {
            cb.checked = true;
        });
    });

    document.getElementById('btn-unselect-all').addEventListener('click', function () {
        document.querySelectorAll('.permission-checkbox').forEach(function (cb) {
            cb.checked = false;
        });
    });
</script>
@endsection
