<?php $__env->startSection('title', 'حركات المخزون'); ?>

<?php $__env->startSection('content'); ?>

    <div class="content-header d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0">حركات المخزون</h5>

        <a href="<?php echo e(route('inventory.items.index')); ?>" class="btn btn-sm btn-outline-secondary">
            الرجوع للمخزون
        </a>
    </div>

    
    <div class="card mb-3">
        <div class="card-header">
            <h6 class="mb-0">تصفية النتائج</h6>
        </div>
        <div class="card-body">
            <form method="GET" class="row gy-2 gx-2">

                <div class="col-md-4">
                    <label class="form-label">الصنف</label>
                    <select name="inventory_item_id" class="form-select">
                        <option value="">الكل</option>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($item->id); ?>"
                                <?php echo e(request('inventory_item_id') == $item->id ? 'selected' : ''); ?>>
                                <?php echo e($item->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </select>
                </div>

                <div class="col-md-2">
                    <label class="form-label">النوع</label>
                    <select name="type" class="form-select">
                        <option value="">الكل</option>
                        <option value="in" <?php echo e(request('type') == 'in' ? 'selected' : ''); ?>>دخول</option>
                        <option value="out" <?php echo e(request('type') == 'out' ? 'selected' : ''); ?>>خروج</option>
                        <option value="adjustment" <?php echo e(request('type') == 'adjustment' ? 'selected' : ''); ?>>تعديل</option>
                    </select>
                </div>

                <div class="col-md-2">
                    <label class="form-label">من تاريخ</label>
                    <input type="date" name="date_from" class="form-control"
                           value="<?php echo e(request('date_from')); ?>">
                </div>

                <div class="col-md-2">
                    <label class="form-label">إلى تاريخ</label>
                    <input type="date" name="date_to" class="form-control"
                           value="<?php echo e(request('date_to')); ?>">
                </div>

                <div class="col-md-2 d-flex align-items-end">
                    <button class="btn btn-primary w-100">
                        بحث
                    </button>
                </div>
            </form>
        </div>
    </div>

    
    <div class="card">
        <div class="card-header">
            <h6 class="mb-0">قائمة الحركات</h6>
        </div>

        <div class="card-body">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($movements->count()): ?>
                <div class="table-responsive">
                    <table class="table table-striped align-middle">
                        <thead>
                        <tr>
                            <th>#</th>
                            <th>التاريخ</th>
                            <th>الصنف</th>
                            <th>النوع</th>
                            <th>الكمية</th>
                            <th>السبب</th>
                            <th>مرجع</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $movements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($mv->id); ?></td>
                                <td><?php echo e($mv->created_at->format('Y-m-d H:i')); ?></td>
                                <td><?php echo e($mv->inventoryItem?->name ?? '-'); ?></td>
                                <td>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($mv->type === 'in'): ?>
                                        <span class="badge bg-success">دخول</span>
                                    <?php elseif($mv->type === 'out'): ?>
                                        <span class="badge bg-danger">خروج</span>
                                    <?php else: ?>
                                        <span class="badge bg-warning text-dark">تعديل</span>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </td>
                                <td><?php echo e($mv->quantity); ?></td>
                                <td><?php echo e($mv->reason ?: '-'); ?></td>
                                <td>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($mv->reference_type && $mv->reference_id): ?>
                                        <?php echo e($mv->reference_type); ?> #<?php echo e($mv->reference_id); ?>

                                    <?php else: ?>
                                        -
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <div class="mt-3">
                    <?php echo e($movements->appends(request()->query())->links()); ?>

                </div>
            <?php else: ?>
                <p class="text-center text-muted mb-0">
                    لا توجد حركات مخزون مطابقة للبحث.
                </p>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\jops\SassMedical\resources\views/admin/inventory/movements/index.blade.php ENDPATH**/ ?>