<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>فاتورة رقم <?php echo e($invoice->invoice_number); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <style>
        @page {
            size: A4;
            margin: 15mm;
        }

        body {
            font-family: "Tahoma", system-ui, -apple-system, "Segoe UI", sans-serif;
            background: #f5f5f5;
            color: #111827;
            margin: 0;
            padding: 0;
        }

        .page {
            background: #ffffff;
            margin: 10px auto;
            padding: 20px 24px;
            max-width: 900px;
            box-shadow: 0 0 10px rgba(0,0,0,0.08);
        }

        .text-center { text-align: center; }
        .text-start { text-align: right; }
        .text-end   { text-align: left; }

        .mb-0 { margin-bottom: 0; }
        .mb-1 { margin-bottom: 4px; }
        .mb-2 { margin-bottom: 8px; }
        .mb-3 { margin-bottom: 12px; }
        .mb-4 { margin-bottom: 16px; }
        .mb-5 { margin-bottom: 20px; }
        .mt-0 { margin-top: 0; }
        .mt-2 { margin-top: 8px; }
        .mt-3 { margin-top: 12px; }

        .fw-bold  { font-weight: 700; }
        .fw-600   { font-weight: 600; }
        .small    { font-size: 0.85rem; }
        .fs-18    { font-size: 1.1rem; }
        .fs-22    { font-size: 1.4rem; }

        .border {
            border: 1px solid #e5e7eb;
        }

        .rounded {
            border-radius: 6px;
        }

        .p-2 { padding: 6px; }
        .p-3 { padding: 12px; }
        .p-4 { padding: 16px; }

        .row {
            display: flex;
            flex-wrap: wrap;
            margin-right: -8px;
            margin-left: -8px;
        }

        .col-6, .col-4, .col-8, .col-12 {
            padding-right: 8px;
            padding-left: 8px;
            box-sizing: border-box;
        }

        .col-12 { width: 100%; }
        .col-8  { width: 66.666%; }
        .col-6  { width: 50%; }
        .col-4  { width: 33.333%; }

        .table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        .table th,
        .table td {
            padding: 6px 8px;
            border: 1px solid #e5e7eb;
            font-size: 0.9rem;
        }

        .table thead th {
            background: #f3f4f6;
            font-weight: 700;
        }

        .badge {
            display: inline-block;
            padding: 2px 8px;
            border-radius: 999px;
            font-size: 0.75rem;
        }

        .badge-unpaid   { background:#fee2e2; color:#b91c1c; }
        .badge-partial  { background:#fef3c7; color:#92400e; }
        .badge-paid     { background:#dcfce7; color:#166534; }
        .badge-refunded { background:#e0f2fe; color:#075985; }

        .text-muted { color: #6b7280; }

        .btn-print {
            position: fixed;
            top: 10px;
            left: 10px;
            padding: 6px 12px;
            background: #111827;
            color: #ffffff;
            border: none;
            border-radius: 4px;
            font-size: 0.9rem;
            cursor: pointer;
            z-index: 9999;
        }

        .currency-icon {
            vertical-align: middle;
        }

        .totals-table td {
            padding: 4px 8px;
            font-size: 0.9rem;
        }

        @media print {
            body {
                background: #ffffff;
            }
            .page {
                margin: 0;
                box-shadow: none;
            }
            .btn-print {
                display: none;
            }
        }
    </style>
</head>
<body>

<button class="btn-print" onclick="window.print()">طباعة</button>

<div class="page">

    
    <div class="row mb-4">
        <div class="col-8">
            <h2 class="mt-0 mb-1 fs-22 fw-600">
                <?php echo e($invoice->clinic?->name ?? 'اسم العيادة'); ?>

            </h2>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($invoice->clinic?->address): ?>
                <div class="small mb-1">
                    العنوان: <?php echo e($invoice->clinic->address); ?>

                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($invoice->clinic?->phone): ?>
                <div class="small mb-1">
                    الجوال: <?php echo e($invoice->clinic->phone); ?>

                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($invoice->branch): ?>
                <div class="small mb-1">
                    الفرع: <?php echo e($invoice->branch->name); ?>

                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>

        <div class="col-4 text-end">
            <h3 class="mt-0 mb-1 fs-18">فاتورة</h3>
            <div class="small mb-1">
                <span class="fw-600">رقم الفاتورة:</span>
                <?php echo e($invoice->invoice_number); ?>

            </div>
            <div class="small mb-1">
                <span class="fw-600">تاريخ الفاتورة:</span>
                <?php echo e($invoice->date?->format('Y-m-d')); ?>

            </div>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($invoice->payment_due_date): ?>
                <div class="small mb-1">
                    <span class="fw-600">تاريخ الاستحقاق:</span>
                    <?php echo e($invoice->payment_due_date?->format('Y-m-d')); ?>

                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <div class="small mb-1">
                <span class="fw-600">الحالة:</span>
                <?php
                    $statusBadgeClass = match($invoice->status) {
                        'paid'     => 'badge-paid',
                        'partial'  => 'badge-partial',
                        'refunded' => 'badge-refunded',
                        default    => 'badge-unpaid',
                    };
                    $statusText = match($invoice->status) {
                        'paid'     => 'مدفوعة',
                        'partial'  => 'مدفوعة جزئياً',
                        'refunded' => 'مستردة',
                        default    => 'غير مدفوعة',
                    };
                ?>
                <span class="badge <?php echo e($statusBadgeClass); ?>">
                    <?php echo e($statusText); ?>

                </span>
            </div>
        </div>
    </div>

    
    <div class="border rounded p-3 mb-4">
        <div class="row">
            <div class="col-6">
                <div class="mb-1">
                    <span class="fw-600">المريض:</span>
                    <?php echo e($invoice->patient?->first_name); ?> <?php echo e($invoice->patient?->last_name); ?>

                </div>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($invoice->patient?->code): ?>
                    <div class="mb-1 small text-muted">
                        كود المريض: <?php echo e($invoice->patient->code); ?>

                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($invoice->patient?->phone): ?>
                    <div class="mb-1 small">
                        الجوال: <?php echo e($invoice->patient->phone); ?>

                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>

            <div class="col-6">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($invoice->patient?->gender): ?>
                    <div class="mb-1 small">
                        <span class="fw-600">النوع:</span>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($invoice->patient->gender === 'male'): ?>
                            ذكر
                        <?php elseif($invoice->patient->gender === 'female'): ?>
                            أنثى
                        <?php else: ?>
                            —
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($invoice->patient?->birth_date): ?>
                    <div class="mb-1 small">
                        <span class="fw-600">تاريخ الميلاد:</span>
                        <?php echo e($invoice->patient->birth_date); ?>

                        <?php
                            try {
                                $age = \Carbon\Carbon::parse($invoice->patient->birth_date)->age;
                            } catch (\Exception $e) {
                                $age = null;
                            }
                        ?>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($age): ?>
                            (<?php echo e($age); ?> سنة)
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($invoice->visit): ?>
                    <div class="mb-1 small">
                        <span class="fw-600">مرتبطة بزيارة رقم:</span>
                        <?php echo e($invoice->visit->id); ?> – <?php echo e($invoice->visit->visit_date ?? ''); ?>

                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($invoice->treatmentPlan): ?>
                    <div class="mb-1 small">
                        <span class="fw-600">خطة علاج:</span>
                        <?php echo e($invoice->treatmentPlan->title ?? ('خطة #' . $invoice->treatmentPlan->id)); ?>

                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
        </div>
    </div>

    
    <table class="table">
        <thead>
        <tr>
            <th style="width: 40px;">#</th>
            <th>الوصف</th>
            <th style="width: 70px;">الكمية</th>
            <th style="width: 120px;">سعر الوحدة</th>
            <th style="width: 120px;">الخصم</th>
            <th style="width: 140px;">الإجمالي الفرعي</th>
        </tr>
        </thead>
        <tbody>
        <?php
            $row = 1;
        ?>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $invoice->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <?php
                $desc = $item->description;
                if ($item->service && !str_contains($desc, $item->service->name)) {
                    // مجرد تحسين بسيط .. اختياري
                    //$desc = $item->service->name . ' - ' . $desc;
                }
            ?>
            <tr>
                <td class="text-center"><?php echo e($row++); ?></td>
                <td><?php echo e($desc); ?></td>
                <td class="text-center"><?php echo e($item->quantity); ?></td>

                <td class="text-center">
                    <?php echo e(number_format($item->unit_price, 2)); ?>

                    <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>"
                         width="14" height="14" class="currency-icon" alt="ر.س">
                </td>

                <td class="text-center">
                    <?php echo e(number_format($item->discount, 2)); ?>

                    <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>"
                         width="14" height="14" class="currency-icon" alt="ر.س">
                </td>

                <td class="text-center">
                    <?php echo e(number_format($item->line_total, 2)); ?>

                    <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>"
                         width="14" height="14" class="currency-icon" alt="ر.س">
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="6" class="text-center">
                    لا توجد بنود في هذه الفاتورة.
                </td>
            </tr>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </tbody>
    </table>

    
    <?php
        $subtotal      = (float) $invoice->subtotal;
        $discount      = (float) $invoice->discount;
        $taxPercent    = (float) $invoice->tax_percent;
        $taxAmount     = (float) $invoice->tax_amount;
        $total         = (float) $invoice->total;
        $paid          = (float) $invoice->paid_amount;
        $due           = $total - $paid;
        if ($due < 0) { $due = 0; }

        $baseAfterDiscount = $subtotal - $discount;
        if ($baseAfterDiscount < 0) { $baseAfterDiscount = 0; }
    ?>

    <div class="row mt-3">
        <div class="col-6">
            <div class="small text-muted">
                المبالغ محسوبة بالريال السعودي.
                في حال وجود أي خطأ، يرجى التواصل مع الإدارة المالية في العيادة.
            </div>
        </div>
        <div class="col-6">
            <table class="totals-table" style="width: 100%;">
                <tr>
                    <td class="text-start fw-600">الإجمالي قبل الخصم:</td>
                    <td class="text-end">
                        <?php echo e(number_format($subtotal, 2)); ?>

                        <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>"
                             width="14" height="14" class="currency-icon" alt="ر.س">
                    </td>
                </tr>
                <tr>
                    <td class="text-start fw-600">إجمالي الخصم:</td>
                    <td class="text-end">
                        <?php echo e(number_format($discount, 2)); ?>

                        <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>"
                             width="14" height="14" class="currency-icon" alt="ر.س">
                    </td>
                </tr>
                <tr>
                    <td class="text-start fw-600">الإجمالي بعد الخصم:</td>
                    <td class="text-end">
                        <?php echo e(number_format($baseAfterDiscount, 2)); ?>

                        <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>"
                             width="14" height="14" class="currency-icon" alt="ر.س">
                    </td>
                </tr>
                <tr>
                    <td class="text-start fw-600">
                        الضريبة (<?php echo e(number_format($taxPercent, 2)); ?>%):
                    </td>
                    <td class="text-end">
                        <?php echo e(number_format($taxAmount, 2)); ?>

                        <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>"
                             width="14" height="14" class="currency-icon" alt="ر.س">
                    </td>
                </tr>
                <tr>
                    <td class="text-start fw-600">الإجمالي النهائي:</td>
                    <td class="text-end fw-bold">
                        <?php echo e(number_format($total, 2)); ?>

                        <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>"
                             width="14" height="14" class="currency-icon" alt="ر.س">
                    </td>
                </tr>
                <tr>
                    <td class="text-start fw-600">المدفوع:</td>
                    <td class="text-end">
                        <?php echo e(number_format($paid, 2)); ?>

                        <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>"
                             width="14" height="14" class="currency-icon" alt="ر.س">
                    </td>
                </tr>
                <tr>
                    <td class="text-start fw-600">المتبقي على المريض:</td>
                    <td class="text-end">
                        <?php echo e(number_format($due, 2)); ?>

                        <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>"
                             width="14" height="14" class="currency-icon" alt="ر.س">
                    </td>
                </tr>
            </table>
        </div>
    </div>

    
    <div class="row mt-4">
        <div class="col-6">
            <div class="small">
                <span class="fw-600">مسؤول الاستقبال:</span> _____________________
            </div>
        </div>
        <div class="col-6 text-end">
            <div class="small">
                <span class="fw-600">توقيع المريض:</span> _____________________
            </div>
        </div>
    </div>

</div>

</body>
</html>
<?php /**PATH D:\jops\SassMedical\resources\views/admin/invoices/print.blade.php ENDPATH**/ ?>