<?php $__env->startSection('title', 'مخزون العيادة'); ?>

<?php $__env->startSection('content'); ?>

    <div class="content-header d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0">مخزون العيادة</h5>

        <a href="<?php echo e(route('inventory.items.create')); ?>" class="btn btn-sm btn-success">
            إضافة صنف جديد
        </a>
    </div>

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('success')): ?>
        <div class="alert alert-success">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    
    <div class="row mb-3">
        <div class="col-md-4">
            <div class="card border-primary">
                <div class="card-body">
                    <h6 class="text-muted mb-1">إجمالي عدد الأصناف</h6>
                    <h4 class="mb-0 fw-bold"><?php echo e($totalItemsCount); ?></h4>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card border-danger">
                <div class="card-body">
                    <h6 class="text-muted mb-1">أصناف أقل من الحد الأدنى</h6>
                    <h4 class="mb-0 fw-bold text-danger"><?php echo e($lowStockCount); ?></h4>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card border-success">
                <div class="card-body">
                    <h6 class="text-muted mb-1">قيمة المخزون (تقريبية)</h6>
                    <h4 class="mb-0 fw-bold">
                        <?php echo e(number_format($totalStockValue, 2)); ?>

                        <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="18" height="18" alt="">
                    </h4>
                </div>
            </div>
        </div>
    </div>

    
    <div class="card table-card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h6 class="mb-0">قائمة الأصناف</h6>
        </div>

        <div class="card-body">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($items->count()): ?>
                <div class="table-responsive">
                    <table class="table table-striped align-middle">
                        <thead>
                        <tr>
                            <th>#</th>
                            <th>اسم الصنف</th>
                            <th>التصنيف</th>
                            <th>الوحدة</th>
                            <th>الحد الأدنى</th>
                            <th>الكمية الحالية</th>
                            <th>سعر الشراء</th>
                            <th>سعر البيع</th>
                            <th>حالة المخزون</th>
                            <th>إجراءات</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $isLow = $item->current_quantity < $item->min_quantity;
                            ?>
                            <tr>
                                <td><?php echo e($item->id); ?></td>
                                <td><?php echo e($item->name); ?></td>
                                <td><?php echo e($item->category ?: '-'); ?></td>
                                <td><?php echo e($item->unit ?: '-'); ?></td>
                                <td><?php echo e($item->min_quantity); ?></td>
                                <td><?php echo e($item->current_quantity); ?></td>
                                <td>
                                    <?php echo e(number_format($item->purchase_price, 2)); ?>

                                    <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="14" height="14" alt="">
                                </td>
                                <td>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($item->sale_price > 0): ?>
                                        <?php echo e(number_format($item->sale_price, 2)); ?>

                                        <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="14" height="14" alt="">
                                    <?php else: ?>
                                        -
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </td>
                                <td>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($isLow): ?>
                                        <span class="badge bg-danger">أقل من الحد الأدنى</span>
                                    <?php else: ?>
                                        <span class="badge bg-success">مخزون كافي</span>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </td>
                                <td>

                                    
                                    <button type="button"
                                            class="btn btn-sm btn-success"
                                            onclick="openStockModal(<?php echo e($item->id); ?>, '<?php echo e($item->name); ?>', 'in')">
                                        + زيادة
                                    </button>

                                    
                                    <button type="button"
                                            class="btn btn-sm btn-warning"
                                            onclick="openStockModal(<?php echo e($item->id); ?>, '<?php echo e($item->name); ?>', 'out')">
                                        - نقصان
                                    </button>
                                    <?php echo $__env->make('admin.inventory.model', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                                    <a href="<?php echo e(route('inventory.items.edit', $item->id)); ?>"
                                       class="btn btn-sm btn-primary">
                                        تعديل
                                    </a>

                                    <form action="<?php echo e(route('inventory.items.destroy', $item->id)); ?>"
                                          method="POST"
                                          class="d-inline"
                                          onsubmit="return confirm('هل تريد حذف هذا الصنف من المخزون؟');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button class="btn btn-sm btn-danger">حذف</button>
                                    </form>

                                </td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <div class="mt-3">
                    <?php echo e($items->links()); ?>

                </div>
            <?php else: ?>
                <p class="text-center text-muted mb-0">
                    لا توجد أصناف في المخزون حتى الآن.
                </p>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script>
        function openStockModal(itemId, itemName, type) {
            let title = (type === 'in')
                ? 'زيادة مخزون: ' + itemName
                : 'نقصان مخزون: ' + itemName;

            document.getElementById('stockModalTitle').innerText = title;
            document.getElementById('stockType').value = type;

            let form = document.getElementById('stockForm');
            form.action = "/inventory/items/" + itemId + "/movement";

            new bootstrap.Modal(document.getElementById('stockModal')).show();
        }
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\jops\SassMedical\resources\views/admin/inventory/index.blade.php ENDPATH**/ ?>