<?php $__env->startSection('title', 'إعدادات العيادة'); ?>

<?php $__env->startSection('content'); ?>

    <div class="content-header mb-3">
        <h5>إعدادات العيادة</h5>
    </div>

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('success')): ?>
        <div class="alert alert-success">
            ✔ <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <strong>من فضلك صحح الأخطاء التالية:</strong>
            <ul class="mb-0">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $err): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($err); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </ul>
        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <div class="card">
        <div class="card-header">
            <h6 class="mb-0">بيانات العيادة</h6>
        </div>

        <form action="<?php echo e(route('settings.clinic.update')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>

            <div class="card-body">
                <div class="row g-3">

                    
                    <div class="col-md-6">
                        <label class="form-label">اسم العيادة *</label>
                        <input type="text" name="name" class="form-control" required
                               value="<?php echo e(old('name', $clinic->name)); ?>">
                    </div>

                    
                    <div class="col-md-6">
                        <label class="form-label">اسم المالك</label>
                        <input type="text" name="owner_name" class="form-control"
                               value="<?php echo e(old('owner_name', $clinic->owner_name)); ?>">
                    </div>

                    
                    <div class="col-md-4">
                        <label class="form-label">الهاتف</label>
                        <input type="text" name="phone" class="form-control"
                               value="<?php echo e(old('phone', $clinic->phone)); ?>">
                    </div>


                    
                    <div class="col-md-4">
                        <label class="form-label">البريد الإلكتروني</label>
                        <input type="email" name="email" class="form-control"
                               value="<?php echo e(old('email', $clinic->email)); ?>">
                    </div>

                    
                    <div class="col-md-12">
                        <label class="form-label">العنوان</label>
                        <textarea name="address" class="form-control" rows="2"><?php echo e(old('address', $clinic->address)); ?></textarea>
                    </div>

                    
                    <div class="col-md-6">
                        <label class="form-label">الرقم الضريبي</label>
                        <input type="text" name="tax_number" class="form-control"
                               value="<?php echo e(old('tax_number', $clinic->tax_number)); ?>">
                    </div>




                </div>
            </div>

            <div class="card-footer text-end">
                <button class="btn btn-primary">حفظ التعديلات</button>
            </div>
        </form>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\jops\SassMedical\resources\views/admin/clinic/index.blade.php ENDPATH**/ ?>