<?php $__env->startSection('css'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('title'); ?>
    عرض بيانات العميل
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="content-header">
        <h5>تعديل بيانات المريض</h5>

    </div>

    <div class="row gy-4">

        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">بيانات المريض</h5>
                    <a href="<?php echo e(route('patients.edit', $patient->id)); ?>" class="btn btn-sm btn-primary">
                        تعديل بيانات المريض
                    </a>
                </div>
                <div class="card-body">

                    <div class="row gy-3">

                        <div class="col-md-3">
                            <label class="fw-bold">كود المريض:</label>
                            <div><?php echo e($patient->code); ?></div>
                        </div>

                        <div class="col-md-3">
                            <label class="fw-bold">الاسم:</label>
                            <div><?php echo e($patient->first_name); ?> <?php echo e($patient->last_name); ?></div>
                        </div>

                        <div class="col-md-3">
                            <label class="fw-bold">الهاتف:</label>
                            <div><?php echo e($patient->phone); ?></div>
                        </div>

                        <div class="col-md-3">
                            <label class="fw-bold">هاتف إضافي:</label>
                            <div><?php echo e($patient->phone_alt ?: '-'); ?></div>
                        </div>

                        <div class="col-md-3">
                            <label class="fw-bold">الجنس:</label>
                            <div>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($patient->gender === 'male'): ?>
                                    ذكر
                                <?php elseif($patient->gender === 'female'): ?>
                                    أنثى
                                <?php else: ?>
                                    -
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <label class="fw-bold">تاريخ الميلاد:</label>
                            <div><?php echo e($patient->birth_date ?: '-'); ?></div>
                        </div>

                        <div class="col-md-6">
                            <label class="fw-bold">العنوان:</label>
                            <div><?php echo e($patient->address ?: '-'); ?></div>
                        </div>

                        <div class="col-md-12">
                            <label class="fw-bold">ملاحظات:</label>
                            <div><?php echo e($patient->notes ?: '-'); ?></div>
                        </div>

                    </div>

                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($patient->medicalRecord): ?>
                        <hr>
                        <h6 class="fw-bold mb-3">الملف الطبي</h6>
                        <div class="row gy-2">
                            <div class="col-md-3">
                                <label class="fw-bold">فصيلة الدم:</label>
                                <div><?php echo e($patient->medicalRecord->blood_type ?: '-'); ?></div>
                            </div>
                            <div class="col-md-9">
                                <label class="fw-bold">الحساسية من أدوية:</label>
                                <div><?php echo e($patient->medicalRecord->allergies ?: '-'); ?></div>
                            </div>
                            <div class="col-md-12">
                                <label class="fw-bold">أمراض مزمنة:</label>
                                <div><?php echo e($patient->medicalRecord->chronic_diseases ?: '-'); ?></div>
                            </div>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                </div>
            </div>
        </div>

        <div class="col-lg-12">
            <div class="card h-100">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">المواعيد</h5>
                </div>
                <div class="card-body">

                    
                    
                    <form action="<?php echo e(route('patients.attachments.store')); ?>" method="POST" class="mb-4">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="form_type" value="appointment">
                        <input type="hidden" name="patient_id" value="<?php echo e($patient->id); ?>">

                        <div class="row g-2 align-items-end">
                            <div class="col-md-5">
                                <label class="form-label">التاريخ *</label>
                                <input type="date" name="appointment_date" class="form-control" required>
                            </div>

                            <div class="col-md-3">
                                <label class="form-label">الوقت *</label>
                                <input type="time" name="start_time" class="form-control" required>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">الطبيب *</label>
                                <select name="doctor_id" class="form-select" required>
                                    <option value="">اختر طبيب</option>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doctor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($doctor->id); ?>">
                                            <?php echo e($doctor->user->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </select>
                            </div>
                        </div>

                        <button class="btn btn-sm btn-primary mt-3">
                            حجز الموعد
                        </button>
                    </form>

                    
                    <div class="table-responsive">
                        <table class="table table-sm table-striped">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>التاريخ</th>
                                <th>الوقت</th>
                                <th>الطبيب</th>
                                <th>الحالة</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $patient->appointments->sortByDesc('appointment_date'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $appointment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($appointment->id); ?></td>
                                    <td><?php echo e($appointment->appointment_date); ?></td>
                                    <td><?php echo e($appointment->start_time); ?></td>
                                    <td><?php echo e($appointment->doctor?->user?->name); ?></td>
                                    <td><?php echo e($appointment->status); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5" class="text-center">لا توجد مواعيد مسجلة لهذا المريض.</td>
                                </tr>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>

        <div class="col-lg-12">
            <div class="card h-100">

                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">إضافة زيارة جديدة للمريض</h5>
                </div>

                <div class="card-body">

                    <form action="<?php echo e(route('patients.attachments.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="form_type" value="visit">
                        <input type="hidden" name="patient_id" value="<?php echo e($patient->id); ?>">

                        <div class="row g-2">
                            <div class="col-md-4">
                                <label class="form-label">تاريخ الزيارة *</label>
                                <input type="date" name="visit_date" class="form-control" required
                                       value="<?php echo e(now()->toDateString()); ?>">
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">الطبيب *</label>
                                <select name="doctor_id" class="form-control" required>
                                    <option value="">اختر طبيب</option>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doctor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($doctor->id); ?>">
                                            <?php echo e($doctor->user->name); ?> (<?php echo e($doctor->specialty->name); ?>)
                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </select>
                            </div>

                            <div class="col-md-12 mt-2">
                                <label class="form-label">الشكوى / سبب الزيارة</label>
                                <input type="text" name="chief_complaint" class="form-control"
                                       placeholder="مثال: ألم في الجانب الأيمن من البطن / ألم ضرس علوي يمين">
                            </div>

                            <div class="col-md-12 mt-2">
                                <label class="form-label">ملاحظات عامة للطبيب (اختياري)</label>
                                <textarea name="notes" rows="2" class="form-control"></textarea>
                            </div>
                        </div>

                        <button class="btn btn-sm btn-outline-success mt-2">
                            حفظ الزيارة
                        </button>
                    </form>
                </div>


            </div>

        </div>

        
        <div class="col-12">
            <div class="card h-100">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">خطط العلاج</h5>

                    <a href="<?php echo e(route('treatment-plans.create', $patient->id)); ?>"
                       class="btn btn-sm btn-success">
                        إضافة خطة علاج جديدة
                    </a>
                </div>

                <div class="card-body">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($patient->treatmentPlans?->count()): ?>
                        <div class="table-responsive">
                            <table class="table table-sm table-striped align-middle">
                                <thead>
                                <tr>
                                    <th>#</th>
                                    <th>العنوان</th>
                                    <th>الطبيب</th>
                                    <th>الحالة</th>
                                    <th>تاريخ الإنشاء</th>
                                    <th>إجراءات</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $patient->treatmentPlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $status = $plan->status;
                                        $badgeClass = match($status) {
                                            'draft'    => 'secondary',
                                            'ongoing'  => 'warning',
                                            'completed'=> 'success',
                                            'cancelled'=> 'danger',
                                            default    => 'secondary',
                                        };
                                    ?>
                                    <tr>
                                        <td><?php echo e($plan->id); ?></td>
                                        <td><?php echo e($plan->title ?? '-'); ?></td>
                                        <td><?php echo e($plan->doctor?->user?->name ?? '-'); ?></td>
                                        <td>
                                    <span class="badge bg-<?php echo e($badgeClass); ?>">
                                        <?php echo e($plan->status); ?>

                                    </span>
                                        </td>
                                        <td><?php echo e($plan->created_at?->format('Y-m-d')); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('treatment-plans.show', $plan->id)); ?>"
                                               class="btn btn-sm btn-outline-primary">
                                                عرض الخطة
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <p class="text-center text-muted mb-0">
                            لا توجد خطط علاج لهذا المريض.
                        </p>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
            </div>
        </div>



        <div class="col-lg-12">
            <div class="card h-100">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">الروشتات الطبية</h5>
                </div>
                <div class="card-body">

                    

                    <form action="<?php echo e(route('patients.attachments.store')); ?>" method="POST" class="mb-4">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="form_type" value="prescription">
                        <input type="hidden" name="patient_id" value="<?php echo e($patient->id); ?>">

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($patient->visits->count()): ?>
                            <div class="mb-2">
                                <label class="form-label">الزيارة المرتبطة</label>
                                <select name="visit_id" class="form-select" required>
                                    <option value="">بدون</option>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $patient->visits->sortByDesc('visit_date'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $visit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($visit->id); ?>">
                                            زيارة رقم <?php echo e($visit->id); ?> - <?php echo e($visit->visit_date); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </select>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>



                        <div class="mb-2">
                            <label class="form-label">ملاحظات الروشتة / التعليمات</label>
                            <textarea name="notes" id="classic-editor" rows="5" class="form-control"
                                      placeholder="اكتب ملاحظات الطبيب أو التعليمات العامة للمريض"></textarea>
                        </div>

                        <button class="btn btn-sm btn-primary mt-1">
                            حفظ الروشتة
                        </button>
                    </form>


                    
                    <div class="prescriptions-list">

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $patient->prescriptions->sortByDesc('created_at'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prescription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="card mb-3 shadow-sm">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <div>
                                        <strong>روشتة رقم #<?php echo e($prescription->id); ?></strong><br>
                                        <small class="text-muted">
                                            <?php echo e($prescription->created_at->format('Y-m-d H:i')); ?>

                                            —
                                            د. <?php echo e($prescription->doctor?->user?->name); ?>

                                        </small>
                                    </div>

                                    <div class="d-flex gap-1">
                                        <button class="btn btn-sm btn-outline-primary"
                                                onclick="document.getElementById('rx-<?php echo e($prescription->id); ?>').classList.toggle('d-none')">
                                            عرض التفاصيل
                                        </button>

                                        <a href="<?php echo e(route('patients.prescriptions.print', $prescription->id)); ?>"
                                           target="_blank"
                                           class="btn btn-sm btn-secondary">
                                            طباعة
                                        </a>
                                    </div>
                                </div>


                                <div class="card-body d-none" id="rx-<?php echo e($prescription->id); ?>">
                                    <div class="rx-text">
                                        <?php echo $prescription->notes; ?>

                                    </div>

                                    
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($prescription->items->count()): ?>
                                        <hr>
                                        <h6 class="fw-bold">الأدوية:</h6>
                                        <ul class="list-group">
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $prescription->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li class="list-group-item">
                                                    <strong><?php echo e($item->medication->name ?? '—'); ?></strong><br>
                                                    <small class="text-muted"><?php echo e($item->instructions); ?></small>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </ul>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                            </div>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="alert alert-warning text-center">
                                لا توجد روشتات مسجلة لهذا المريض.
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                    </div>

                </div>
            </div>
        </div>

        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">فواتير المريض</h5>

                    <a href="<?php echo e(route('invoices.index')); ?>" class="btn btn-sm btn-outline-secondary">
                        كل الفواتير
                    </a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm table-striped align-middle">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>رقم الفاتورة</th>
                                <th>التاريخ</th>
                                <th class="text-end">الإجمالي</th>
                                <th class="text-end">المدفوع</th>
                                <th class="text-end">المتبقي</th>
                                <th>الحالة</th>
                                <th>دفع</th>
                                <th>عرض</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $i = 1; ?>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $patient->invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php
                                    $remaining = max($invoice->total - $invoice->paid_amount, 0);
                                ?>
                                <tr>
                                    <td><?php echo e($i++); ?></td>
                                    <td><?php echo e($invoice->invoice_number); ?></td>
                                    <td><?php echo e($invoice->date->format('Y-m-d')); ?></td>
                                    <td class="text-end">
                                        <?php echo e(number_format($invoice->total, 2)); ?>

                                        <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="14" height="14" alt="">
                                    </td>
                                    <td class="text-end">
                                        <?php echo e(number_format($invoice->paid_amount, 2)); ?>

                                        <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="14" height="14" alt="">
                                    </td>
                                    <td class="text-end">
                                        <?php echo e(number_format($remaining, 2)); ?>

                                        <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="14" height="14" alt="">
                                    </td>
                                    <td>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php switch($invoice->status):
                                            case ('unpaid'): ?>
                                                <span class="badge bg-danger">غير مدفوعة</span>
                                                <?php break; ?>
                                            <?php case ('partial'): ?>
                                                <span class="badge bg-warning text-dark">مدفوعة جزئياً</span>
                                                <?php break; ?>
                                            <?php case ('paid'): ?>
                                                <span class="badge bg-success">مدفوعة بالكامل</span>
                                                <?php break; ?>
                                            <?php case ('refunded'): ?>
                                                <span class="badge bg-secondary">مسترجعة</span>
                                                <?php break; ?>
                                        <?php endswitch; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </td>

                                    <td>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($remaining > 0): ?>
                                            <form action="<?php echo e(route('payments.store')); ?>" method="POST"
                                                  class="d-flex gap-1 align-items-center">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="invoice_id" value="<?php echo e($invoice->id); ?>">

                                                <input type="number" step="0.01" min="0.01"
                                                       max="<?php echo e($remaining); ?>"
                                                       name="amount"
                                                       class="form-control form-control-sm"
                                                       style="max-width: 110px"
                                                       value="<?php echo e($remaining); ?>">

                                                <select name="payment_method"
                                                        class="form-select form-select-sm"
                                                        style="max-width: 110px">
                                                    <option value="cash">كاش</option>
                                                    <option value="card">بطاقة</option>
                                                    <option value="bank_transfer">تحويل</option>
                                                    <option value="online">أونلاين</option>
                                                </select>

                                                <button type="submit" class="btn btn-sm btn-success">
                                                    دفع
                                                </button>
                                            </form>
                                        <?php else: ?>
                                            <span class="text-success">لا يوجد متبقي</span>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </td>

                                    <td>
                                        <a href="<?php echo e(route('invoices.show', $invoice->id)); ?>"
                                           class="btn btn-sm btn-outline-primary">
                                            عرض
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="9" class="text-center text-muted">
                                        لا توجد فواتير لهذا المريض حتى الآن.
                                    </td>
                                </tr>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>



        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">الملفات والمرفقات</h5>
                </div>
                <div class="card-body">


                    <form action="<?php echo e(route('patients.attachments.store')); ?>" method="POST"
                          enctype="multipart/form-data" class="mb-4">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="form_type" value="attachment">
                        <input type="hidden" name="patient_id" value="<?php echo e($patient->id); ?>">

                        <div class="row g-2 align-items-end">
                            <div class="col-md-4">
                                <label class="form-label">الملف *</label>
                                <input type="file" name="file" class="form-control" required>
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">نوع الملف</label>
                                <input type="text" name="file_type" class="form-control"
                                       placeholder="أشعة، تحاليل، تقرير...">
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">وصف</label>
                                <input type="text" name="description" class="form-control">
                            </div>
                        </div>

                        <button class="btn btn-sm btn-primary mt-3">
                            رفع المرفق
                        </button>
                    </form>


                    
                    <div class="table-responsive">
                        <table class="table table-sm table-striped">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>الملف</th>
                                <th>النوع</th>
                                <th>الوصف</th>
                                <th>التاريخ</th>
                                <th>إجراءات</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $patient->attachments->sortByDesc('created_at'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attachment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($attachment->id); ?></td>
                                    <td>
                                        <a href="<?php echo e(asset($attachment->file_path)); ?>" target="_blank">
                                            عرض الملف
                                        </a>
                                    </td>
                                    <td><?php echo e($attachment->file_type ?: '-'); ?></td>
                                    <td><?php echo e($attachment->description ?: '-'); ?></td>
                                    <td><?php echo e($attachment->created_at->format('Y-m-d H:i')); ?></td>
                                    <td>
                                        <form action="<?php echo e(route('patients.attachments.destroy', $attachment->id)); ?>"
                                              method="POST"
                                              onsubmit="return confirm('حذف هذا المرفق؟');">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button class="btn btn-sm btn-danger">
                                                حذف
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" class="text-center">لا توجد مرفقات لهذا المريض.</td>
                                </tr>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('dash/assets/js/plugins/ckeditor/classic/ckeditor.js')); ?>"></script>
    <script type="text/javascript">
        (function () {
            ClassicEditor.create(document.querySelector('#classic-editor'))
                .catch(error => {
                    console.error(error);
                });
        })();
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\jops\SassMedical\resources\views/admin/patients/show.blade.php ENDPATH**/ ?>