<?php $__env->startSection('title', 'الفواتير'); ?>

<?php $__env->startSection('content'); ?>

    <div class="content-header d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0">كل الفواتير</h5>
        <a href="<?php echo e(route('invoices.create')); ?>" class="btn btn-sm btn-primary">
            إضافة فاتورة جديدة
        </a>
    </div>

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <div class="card table-card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table" id="pc-dt-simple">
                    <thead>
                    <tr>
                        <th class="text-start">#</th>
                        <th class="text-start">رقم الفاتورة</th>
                        <th class="text-start">تاريخ الفاتورة</th>
                        <th class="text-start">المريض</th>
                        <th class="text-start">العيادة / الفرع</th>
                        <th class="text-start">الإجمالي</th>
                        <th class="text-start">المدفوع</th>
                        <th class="text-start">الحالة</th>
                        <th class="text-start">إجراءات</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $i = ($invoices->currentPage() - 1) * $invoices->perPage() + 1; ?>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <?php
                            $statusBadgeClass = match($invoice->status) {
                                'paid'     => 'badge bg-success',
                                'partial'  => 'badge bg-warning',
                                'refunded' => 'badge bg-info',
                                default    => 'badge bg-danger',
                            };
                            $statusText = match($invoice->status) {
                                'paid'     => 'مدفوعة',
                                'partial'  => 'مدفوعة جزئياً',
                                'refunded' => 'مستردة',
                                default    => 'غير مدفوعة',
                            };
                        ?>
                        <tr>
                            <td><?php echo e($i++); ?></td>
                            <td><?php echo e($invoice->invoice_number); ?></td>
                            <td><?php echo e($invoice->date?->format('Y-m-d')); ?></td>
                            <td>
                                <?php echo e($invoice->patient?->first_name); ?> <?php echo e($invoice->patient?->last_name); ?>

                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($invoice->patient?->code): ?>
                                    <br>
                                    <small class="text-muted">(<?php echo e($invoice->patient->code); ?>)</small>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </td>
                            <td>
                                <?php echo e($invoice->clinic?->name ?? '-'); ?>

                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($invoice->branch): ?>
                                    <br><small class="text-muted">فرع: <?php echo e($invoice->branch->name); ?></small>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </td>
                            <td>
                                <?php echo e(number_format($invoice->total, 2)); ?>

                                <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="14" height="14" alt="ر.س">
                            </td>
                            <td>
                                <?php echo e(number_format($invoice->paid_amount, 2)); ?>

                                <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="14" height="14" alt="ر.س">
                            </td>
                            <td>
                                <span class="<?php echo e($statusBadgeClass); ?>"><?php echo e($statusText); ?></span>
                            </td>
                            <td>
                                <a href="<?php echo e(route('invoices.show', $invoice->id)); ?>"
                                   class="btn btn-sm btn-outline-primary">
                                    عرض
                                </a>

                                <a href="<?php echo e(route('invoices.edit', $invoice->id)); ?>"
                                   class="btn btn-sm btn-outline-primary">تعديل</a>

                                <a href="<?php echo e(route('invoices.invoices_print', $invoice->id)); ?>"
                                   target="_blank"
                                   class="btn btn-sm btn-outline-secondary">
                                    طباعة
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="9" class="text-center text-muted">
                                لا توجد فواتير مسجلة حتى الآن.
                            </td>
                        </tr>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </tbody>
                </table>
            </div>

            <div class="mt-3">
                <?php echo e($invoices->links()); ?>

            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\jops\SassMedical\resources\views/admin/invoices/index.blade.php ENDPATH**/ ?>