<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>نظام إدارة العيادات الطبية – عرض للعميل</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap RTL -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <!-- Icons (اختياري) -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" rel="stylesheet"/>

    <style>
        body {
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
            background-color: #f7f7f9;
        }
        .hero {
            background: linear-gradient(135deg, #2563eb, #1d4ed8);
            color: #fff;
            padding: 3rem 0 4rem;
        }
        .hero-badge {
            background: rgba(255,255,255,0.12);
            border-radius: 999px;
            padding: 0.25rem 0.9rem;
            font-size: 0.85rem;
        }
        .hero-title {
            font-size: 2.2rem;
            font-weight: 800;
        }
        .hero-subtitle {
            font-size: 1rem;
            opacity: 0.9;
        }
        .btn-cta-main {
            background: #f97316;
            border-color: #f97316;
            font-weight: 600;
        }
        .btn-cta-main:hover {
            background: #ea580c;
            border-color: #ea580c;
        }
        .section-title {
            font-weight: 700;
            margin-bottom: 1rem;
        }
        .feature-icon {
            width: 40px;
            height: 40px;
            border-radius: 999px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .price-card {
            border-radius: 1rem;
            border-width: 2px;
        }
        .price-card.popular {
            border-color: #2563eb;
            box-shadow: 0 10px 30px rgba(37,99,235,0.18);
        }
        .badge-tag {
            font-size: 0.75rem;
            border-radius: 999px;
        }
        .whatsapp-btn {
            background: #22c55e;
            border-color: #22c55e;
            font-weight: 600;
        }
        .whatsapp-btn:hover {
            background: #16a34a;
            border-color: #16a34a;
        }
        .small-label {
            font-size: 0.8rem;
            color: #6b7280;
        }
        footer {
            background-color: #0f172a;
            color: #cbd5f5;
            padding: 1.5rem 0;
            font-size: 0.9rem;
        }
        html {
            scroll-behavior: smooth;
        }
    </style>
</head>
<body>

<!-- NAVBAR بسيط -->
<nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm sticky-top">
    <div class="container">
        <a class="navbar-brand fw-bold text-primary" href="#">
            نظام إدارة العيادات
        </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                data-bs-target="#mainNavbar" aria-controls="mainNavbar"
                aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="mainNavbar">
            <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                <li class="nav-item"><a class="nav-link" href="#features">المميزات</a></li>
                <li class="nav-item"><a class="nav-link" href="#specialties">التخصصات</a></li>
                <li class="nav-item"><a class="nav-link" href="#pricing">الأسعار</a></li>
                <li class="nav-item"><a class="nav-link" href="#demo">عرض تجريبي</a></li>
            </ul>
            <div class="d-flex gap-2">
                <a href="#demo" class="btn btn-outline-primary btn-sm">طلب عرض تجريبي</a>
                <a href="#pricing" class="btn btn-cta-main btn-sm text-white">معرفة الأسعار</a>
            </div>
        </div>
    </div>
</nav>

<!-- HERO -->
<section class="hero">
    <div class="container">
        <div class="row align-items-center gy-4">
            <div class="col-lg-6">
                <span class="hero-badge mb-2 d-inline-flex align-items-center gap-2">
                    <i class="fa-solid fa-check-circle"></i>
                    نظام متكامل لإدارة العيادات والمراكز الطبية
                </span>
                <h1 class="hero-title mt-3">
                    كل شغل العيادة<br>في نظام واحد بسيط وسهل
                </h1>
                <p class="hero-subtitle mt-3">
                    إدارة المرضى، المواعيد، خطط العلاج، الفواتير، المدفوعات، المخزون، المستخدمين والصلاحيات –
                    كل ده في نظام واحد يدعم العيادات في السعودية ومصر ودول الخليج.
                </p>
                <div class="d-flex flex-wrap gap-2 mt-4">
                    <a href="#demo" class="btn btn-cta-main px-4">
                        جرّب النظام الآن
                    </a>
                    <a href="#pricing" class="btn btn-outline-light px-4">
                        عرض خطط الأسعار
                    </a>
                </div>
                <div class="mt-4 small">
                    <i class="fa-solid fa-shield-halved"></i>
                    بياناتك محفوظة وآمنة – نسخ احتياطي وتشفير على مستوى عالي
                </div>
            </div>
            <div class="col-lg-6">
                <!-- Mock شاشة للنظام (مجرد ديزاين بسيط) -->
                <div class="bg-white text-dark rounded-4 shadow-lg p-3">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <span class="fw-bold">لوحة متابعة العيادة</span>
                        <span class="badge bg-success">Online</span>
                    </div>
                    <div class="row g-3">
                        <div class="col-6">
                            <div class="border rounded-3 p-3">
                                <div class="small-label">عدد المرضى</div>
                                <div class="fw-bold fs-4">+250</div>
                                <div class="small text-success">
                                    <i class="fa-solid fa-arrow-up"></i> زيادة هذا الشهر
                                </div>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="border rounded-3 p-3">
                                <div class="small-label">مواعيد اليوم</div>
                                <div class="fw-bold fs-4">18</div>
                                <div class="small text-muted">أقرب موعد بعد 20 دقيقة</div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="border rounded-3 p-3">
                                <div class="d-flex justify-content-between">
                                    <span class="small-label">إجمالي الفواتير اليوم</span>
                                    <span class="fw-bold">
                                        7,430
                                        <span class="small text-muted">ر.س</span>
                                    </span>
                                </div>
                                <div class="progress mt-2" style="height: 6px;">
                                    <div class="progress-bar bg-primary" style="width: 70%;"></div>
                                </div>
                                <div class="d-flex justify-content-between mt-1 small text-muted">
                                    <span>الهدف الشهري</span>
                                    <span>70%</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mt-3 small text-muted">
                        * الصورة مجرد مثال توضيحي لشكل لوحة المتابعة داخل النظام.
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- FEATURES -->
<section id="features" class="py-5">
    <div class="container">
        <h2 class="section-title text-center mb-4">أهم مميزات النظام</h2>
        <p class="text-center text-muted mb-5">
            النظام مصمم مخصوص لاحتياج العيادات والمراكز الصحية في السعودية ودول الخليج مع دعم كامل للغة العربية.
        </p>
        <div class="row g-4">
            <div class="col-md-4">
                <div class="bg-white border rounded-4 p-3 h-100">
                    <div class="feature-icon bg-primary bg-opacity-10 text-primary mb-2">
                        <i class="fa-solid fa-user-doctor"></i>
                    </div>
                    <h5>إدارة المرضى والملف الطبي</h5>
                    <p class="text-muted small mb-0">
                        بيانات المريض، التاريخ المرضي، الحساسية، الأمراض المزمنة، المرفقات (أشعة، تحاليل)،
                        وخطط العلاج والروشتات في مكان واحد.
                    </p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="bg-white border rounded-4 p-3 h-100">
                    <div class="feature-icon bg-success bg-opacity-10 text-success mb-2">
                        <i class="fa-solid fa-calendar-check"></i>
                    </div>
                    <h5>مواعيد وعيادات متعددة</h5>
                    <p class="text-muted small mb-0">
                        حجز وإدارة المواعيد، ربط كل موعد بالدكتور والفرع، متابعة حالة الحضور،
                        وتنبيهات بالمواعيد القادمة.
                    </p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="bg-white border rounded-4 p-3 h-100">
                    <div class="feature-icon bg-warning bg-opacity-10 text-warning mb-2">
                        <i class="fa-solid fa-file-medical"></i>
                    </div>
                    <h5>خطط علاج وفواتير مرتبطة</h5>
                    <p class="text-muted small mb-0">
                        إنشاء خطة علاج لكل مريض وربطها تلقائيًا بالفواتير، بحيث البنود في الفاتورة
                        تطلع من خطة العلاج بدون تكرار إدخال البيانات.
                    </p>
                </div>
            </div>

            <div class="col-md-4">
                <div class="bg-white border rounded-4 p-3 h-100">
                    <div class="feature-icon bg-info bg-opacity-10 text-info mb-2">
                        <i class="fa-solid fa-receipt"></i>
                    </div>
                    <h5>فواتير ومدفوعات</h5>
                    <p class="text-muted small mb-0">
                        إنشاء فواتير، خصومات، ضرائب، مدفوعات جزئية أو كاملة، وطباعة الفاتورة باسم العيادة
                        مع شعارها وبياناتها الضريبية.
                    </p>
                </div>
            </div>

            <div class="col-md-4">
                <div class="bg-white border rounded-4 p-3 h-100">
                    <div class="feature-icon bg-danger bg-opacity-10 text-danger mb-2">
                        <i class="fa-solid fa-boxes-stacked"></i>
                    </div>
                    <h5>مخزون وصيدلية</h5>
                    <p class="text-muted small mb-0">
                        إدارة أصناف المخزون (أدوات، مستهلكات، أدوية)، حركات دخول وخروج، تنبيهات عند
                        قرب انتهاء الكمية، وربط استهلاك المخزون بخدمات وخطط العلاج.
                    </p>
                </div>
            </div>

            <div class="col-md-4">
                <div class="bg-white border rounded-4 p-3 h-100">
                    <div class="feature-icon bg-secondary bg-opacity-10 text-secondary mb-2">
                        <i class="fa-solid fa-users-gear"></i>
                    </div>
                    <h5>مستخدمون وصلاحيات</h5>
                    <p class="text-muted small mb-0">
                        تعريف مستخدمين بأدوار مختلفة (مالك، دكتور، استقبال، محاسب، ممرضة، أدمن)
                        مع تحديد ما يشاهده كل شخص داخل النظام.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- SPECIALTIES -->
<section id="specialties" class="py-5 bg-white">
    <div class="container">
        <h2 class="section-title text-center mb-4">مناسب لمراكز وأنواع مختلفة</h2>
        <p class="text-center text-muted mb-5">
            النظام مرن، يشتغل مع أكثر من نوع مركز طبي بدون تعديل كبير في الكود.
        </p>
        <div class="row g-4">
            <div class="col-md-3">
                <div class="border rounded-4 p-3 h-100 text-center">
                    <i class="fa-solid fa-tooth fa-2x text-primary mb-2"></i>
                    <h6>عيادات الأسنان</h6>
                    <p class="small text-muted mb-0">
                        خطط علاج للأسنان، حشو، عصب، تركيبات، زراعة، تبييض، مع إمكانية ربطها بالفواتير والمخزون.
                    </p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="border rounded-4 p-3 h-100 text-center">
                    <i class="fa-solid fa-weight-scale fa-2x text-success mb-2"></i>
                    <h6>مراكز التخسيس والتغذية</h6>
                    <p class="small text-muted mb-0">
                        جلسات متابعة، خطط غذائية، برامج اشتراك شهرية، وحسابات مالية لكل عميل.
                    </p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="border rounded-4 p-3 h-100 text-center">
                    <i class="fa-solid fa-syringe fa-2x text-danger mb-2"></i>
                    <h6>الجلدية والليزر</h6>
                    <p class="small text-muted mb-0">
                        جلسات ليزر وبوتوكس وفيلر، باقات خدمات، ومتابعة صور قبل / بعد كمرفقات للملف الطبي.
                    </p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="border rounded-4 p-3 h-100 text-center">
                    <i class="fa-solid fa-user-plus fa-2x text-warning mb-2"></i>
                    <h6>مراكز زراعة الشعر</h6>
                    <p class="small text-muted mb-0">
                        متابعة مراحل العملية، الجلسات، الأدوية المصاحبة، والتقييمات بعد العملية.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- PRICING -->
<section id="pricing" class="py-5">
    <div class="container">
        <h2 class="section-title text-center mb-4">نظام الاشتراكات</h2>
        <p class="text-center text-muted mb-5">
            تقدر تبدأ بباقات بسيطة، ومع زيادة عدد الأفرع والأطباء نقدر نضبط باقة خاصة تناسب حجم المركز.
        </p>

        <div class="row g-4 justify-content-center">
            <!-- Starter -->
            <div class="col-md-4">
                <div class="card price-card h-100 border-light">
                    <div class="card-body">
                        <span class="badge bg-light text-dark badge-tag mb-2">
                            مركز / عيادة واحدة – طبيب واحد
                        </span>
                        <h4 class="fw-bold">باقة البداية</h4>
                        <p class="text-muted small">
                            مناسبة للعيادات الصغيرة التي تبدأ في تنظيم شغلها.
                        </p>
                        <h3 class="fw-bold mt-3">
                            149
                            <span class="fs-6 text-muted">ر.س / شهر</span>
                        </h3>
                        <ul class="list-unstyled mt-3 mb-4 small">
                            <li><i class="fa-solid fa-check text-success"></i> طبيب واحد / فرع واحد</li>
                            <li><i class="fa-solid fa-check text-success"></i> عدد مرضى غير محدود</li>
                            <li><i class="fa-solid fa-check text-success"></i> إدارة مواعيد وفواتير كاملة</li>
                            <li><i class="fa-solid fa-check text-success"></i> دعم عبر واتساب</li>
                        </ul>
                        <a href="#demo" class="btn btn-outline-primary w-100">
                            اطلب عرض لهذه الباقة
                        </a>
                    </div>
                </div>
            </div>

            <!-- Popular -->
            <div class="col-md-4">
                <div class="card price-card h-100 border-primary popular">
                    <div class="card-body">
                        <span class="badge bg-primary text-white badge-tag mb-2">
                            الأكثر استخداماً
                        </span>
                        <h4 class="fw-bold">باقة المراكز</h4>
                        <p class="text-muted small">
                            مناسبة للمراكز المتوسطة بعدة أطباء وموظفي استقبال.
                        </p>
                        <h3 class="fw-bold mt-3">
                            299
                            <span class="fs-6 text-muted">ر.س / شهر</span>
                        </h3>
                        <ul class="list-unstyled mt-3 mb-4 small">
                            <li><i class="fa-solid fa-check text-success"></i> حتى 5 أطباء</li>
                            <li><i class="fa-solid fa-check text-success"></i> أكثر من فرع واحد إذا احتجت</li>
                            <li><i class="fa-solid fa-check text-success"></i> مخزون وصيدلية + خطط علاج</li>
                            <li><i class="fa-solid fa-check text-success"></i> تخصيص بسيط حسب احتياجك</li>
                        </ul>
                        <a href="#demo" class="btn btn-cta-main w-100 text-white">
                            تواصل لتجربة الباقة
                        </a>
                    </div>
                </div>
            </div>

            <!-- Enterprise -->
            <div class="col-md-4">
                <div class="card price-card h-100 border-light">
                    <div class="card-body">
                        <span class="badge bg-dark text-white badge-tag mb-2">
                            للمجموعات الطبية الكبيرة
                        </span>
                        <h4 class="fw-bold">باقة خاصة</h4>
                        <p class="text-muted small">
                            للحالات التي تحتاج تكاملات خاصة أو عدد كبير من الفروع والأطباء.
                        </p>
                        <h3 class="fw-bold mt-3">
                            حسب الاتفاق
                        </h3>
                        <ul class="list-unstyled mt-3 mb-4 small">
                            <li><i class="fa-solid fa-check text-success"></i> عدد فروع وأطباء كبير</li>
                            <li><i class="fa-solid fa-check text-success"></i> استضافة خاصة / على سيرفر العميل</li>
                            <li><i class="fa-solid fa-check text-success"></i> تعديلات مخصصة وتكامل مع أنظمة أخرى</li>
                            <li><i class="fa-solid fa-check text-success"></i> دعم أولوية عالية</li>
                        </ul>
                        <a href="#demo" class="btn btn-outline-dark w-100">
                            احجز مكالمة لمعرفة التفاصيل
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <p class="text-center text-muted mt-4 small">
            * الأسعار مبدئية، ويتم تأكيدها بعد معرفة حجم العيادة وعدد الأطباء والفروع واحتياجك من التعديلات الخاصة.
        </p>
    </div>
</section>

<!-- DEMO & WHATSAPP FORM -->
<section id="demo" class="py-5 bg-white">
    <div class="container">
        <div class="row g-4 align-items-start">
            <div class="col-lg-6">
                <h2 class="section-title mb-3">عايز تشوف النظام فعليًا قبل ما تقرر؟</h2>
                <p class="text-muted mb-3">
                    املأ البيانات البسيطة دي، وهيوصلك رد على واتساب بموعد مناسب
                    لشرح النظام + فيديو توضيحي يشرح طريقة العمل بالكامل.
                </p>

                <div class="bg-light border rounded-4 p-3 mb-3">
                    <div class="d-flex align-items-start gap-2">
                        <div class="text-primary mt-1">
                            <i class="fa-solid fa-circle-info"></i>
                        </div>
                        <div class="small">
                            <strong>إزاي بنشتغل؟</strong><br>
                            • بنسمع منك احتياج العيادة (عدد الأطباء، التخصص، عدد الفروع).<br>
                            • بنظبط إعدادات النظام حسب شغلك.<br>
                            • بنسلمك يوزرات جاهزة + تدريب بسيط لأفراد الفريق.
                        </div>
                    </div>
                </div>

                <!-- FORM -->
                <div class="bg-white border rounded-4 p-3 shadow-sm">
                    <form id="demo-form" onsubmit="return false;">
                        <div class="mb-2">
                            <label class="form-label">اسم المركز / العيادة</label>
                            <input type="text" id="clinic_name" class="form-control"
                                   placeholder="مثال: عيادة الدكتور أحمد للأسنان">
                        </div>
                        <div class="mb-2">
                            <label class="form-label">الدولة</label>
                            <select id="country" class="form-select">
                                <option value="">اختر الدولة</option>
                                <option>السعودية</option>
                                <option>مصر</option>
                                <option>الإمارات</option>
                                <option>الكويت</option>
                                <option>قطر</option>
                                <option>دولة أخرى</option>
                            </select>
                        </div>
                        <div class="mb-2">
                            <label class="form-label">رقم الواتساب للتواصل</label>
                            <input type="text" id="client_whatsapp" class="form-control"
                                   placeholder="مثال: 9665XXXXXXXX">
                        </div>
                        <div class="mb-2">
                            <label class="form-label">نوع التخصص</label>
                            <select id="specialty" class="form-select">
                                <option>أسنان</option>
                                <option>تخسيس</option>
                                <option>جلدية / ليزر</option>
                                <option>زراعة شعر</option>
                                <option>عيادة عامة</option>
                                <option>أخرى</option>
                            </select>
                        </div>
                        <button type="button" id="send-whatsapp" class="btn whatsapp-btn w-100 mt-2">
                            <i class="fa-brands fa-whatsapp"></i>
                            إرسال طلب العرض عبر واتساب
                        </button>
                    </form>
                    <p class="small text-muted mt-2 mb-0">
                        سيتم فتح واتساب على رقم المطور مباشرة مع رسالة تحتوي كل البيانات التي قمت بإدخالها.
                    </p>
                </div>
            </div>

            <div class="col-lg-6">
                <h5 class="mb-3">ماذا سيحصل العميل عند الاشتراك؟</h5>
                <ul class="list-group mb-3 small">
                    <li class="list-group-item">
                        <i class="fa-solid fa-circle-check text-success"></i>
                        تثبيت وإعداد النظام للعيادة (بيانات العيادة، الشعار، الضرائب، الدول/العملة).
                    </li>
                    <li class="list-group-item">
                        <i class="fa-solid fa-circle-check text-success"></i>
                        عدد مستخدمين حسب الباقة (دكتور، استقبال، محاسب، مالك).
                    </li>
                    <li class="list-group-item">
                        <i class="fa-solid fa-circle-check text-success"></i>
                        شرح عملي سريع للفريق وكيف يدير المرضى والمواعيد والفواتير.
                    </li>
                    <li class="list-group-item">
                        <i class="fa-solid fa-circle-check text-success"></i>
                        دعم فني خلال فترة التشغيل الأولى لضبط أي إعدادات إضافية تحتاجها.
                    </li>
                </ul>

                <div class="bg-light rounded-4 p-3">
                    <h6 class="fw-bold mb-2">مناسب للسعودية ودول الخليج</h6>
                    <p class="small text-muted mb-1">
                        • عملة: ريال سعودي أو أي عملة أخرى (جنيه مصري – درهم – دينار).<br>
                        • يدعم ضريبة القيمة المضافة (VAT) بنسبة يمكن تعديلها.<br>
                        • إمكانية التعديل على الفواتير لتناسب اشتراطات كل دولة.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- FOOTER -->
<footer>
    <div class="container d-flex flex-wrap justify-content-between align-items-center gap-2">
        <div>
            &copy; <span id="year"></span> نظام إدارة العيادات – جميع الحقوق محفوظة.
        </div>
        <div class="small">
            للتواصل المباشر عبر واتساب:
            <!-- تقدر تخلي اللينك نفسه نفس رقم OWNER_WHATSAPP -->
            <a href="https://wa.me/2010XXXXXXX" target="_blank" class="text-success text-decoration-none">
                <i class="fa-brands fa-whatsapp"></i> اضغط هنا
            </a>
        </div>
    </div>
</footer>

<!-- JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
    // سنة الفوتر
    document.getElementById('year').textContent = new Date().getFullYear();
</script>

<!-- WhatsApp Logic -->
<script>
    (function () {
        // ✳️ غيّر الرقم ده لرقمك أنت بصيغة دولية بدون +
        // مثال مصر: 2010xxxxxxx — السعودية: 9665xxxxxxx
        const OWNER_WHATSAPP = '201111289180';

        const btn = document.getElementById('send-whatsapp');
        if (!btn) return;

        btn.addEventListener('click', function () {
            const clinicName  = document.getElementById('clinic_name').value.trim();
            const country     = document.getElementById('country').value.trim();
            const clientWhats = document.getElementById('client_whatsapp').value.trim();
            const specialty   = document.getElementById('specialty').value.trim();

            if (!clinicName || !clientWhats) {
                alert('من فضلك أدخل اسم المركز ورقم الواتساب للتواصل.');
                return;
            }

            let message = ''
                + '📩 طلب عرض تجريبي للنظام' + '\n\n'
                + 'اسم المركز / العيادة: ' + clinicName + '\n'
                + 'الدولة: ' + (country || 'غير محدد') + '\n'
                + 'تخصص المركز: ' + (specialty || 'غير محدد') + '\n'
                + 'رقم واتساب العميل: ' + clientWhats + '\n\n'
                + 'الرسالة مرسلة من صفحة عرض النظام.';

            const url = 'https://wa.me/' + OWNER_WHATSAPP
                + '?text=' + encodeURIComponent(message);

            window.open(url, '_blank');
        });
    })();
</script>

</body>
</html>
<?php /**PATH D:\jops\SassMedical\resources\views/welcome.blade.php ENDPATH**/ ?>