<?php $__env->startSection('title', 'لوحة التحكم'); ?>

<?php $__env->startSection('css'); ?>
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col-12">

            
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body bg-primary rounded-3">
                            <div class="row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <div class="d-lg-flex justify-content-between align-items-center ">
                                        <div class="d-md-flex align-items-center">
                                            <img src="<?php echo e(asset('dash/assets/images/user/avatar-2.jpg')); ?>" alt="Image"
                                                 class="rounded-circle avatar avatar-xl">
                                            <div class="mt-3 ms-md-4">
                                                <h2 class="mb-1 text-white fw-600">
                                                    أهلاً، <?php echo e($user->name); ?>

                                                </h2>
                                                <p class="text-white mb-1">
                                                    عيادة: <?php echo e($user->clinic?->name ?? '-'); ?>

                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($user->branch): ?>
                                                        — فرع: <?php echo e($user->branch->name); ?>

                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                </p>
                                                <small class="text-white-50">
                                                    نظرة سريعة على أداء المركز اليوم.
                                                </small>
                                            </div>
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            
            <div class="row mt-2">

                <div class="col-xl-3 col-sm-6">
                    <div class="card">
                        <div class="border rounded card-body border-success bg-light-success">
                            <div class="d-flex align-items-center">
                                <div class="numbers flex-grow-1 pe-3">
                                    <p class="mb-1 fw-600 text-muted">إجمالي المرضى</p>
                                    <h4 class="mb-0 fw-700 text-dark-black">
                                        <?php echo e($totalPatients); ?>

                                    </h4>
                                </div>
                                <div class="icon-shape bg-success ">
                                    <i class="ti ti-users"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-sm-6">
                    <div class="card">
                        <div class="border rounded card-body border-info bg-light">
                            <div class="d-flex align-items-center">
                                <div class="numbers flex-grow-1 pe-3">
                                    <p class="mb-1 fw-600 text-muted">مرضى جدد اليوم</p>
                                    <h4 class="mb-0 fw-700 text-dark-black">
                                        <?php echo e($newPatientsToday); ?>

                                    </h4>
                                </div>
                                <div class="icon-shape bg-info ">
                                    <i class="ti ti-user-plus"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-sm-6">
                    <div class="card">
                        <div class="border rounded card-body border-warning bg-light-warning">
                            <div class="d-flex align-items-center">
                                <div class="numbers flex-grow-1 pe-3">
                                    <p class="mb-1 fw-600 text-muted">مواعيد اليوم</p>
                                    <h4 class="mb-0 fw-700 text-dark-black">
                                        <?php echo e($todayAppointments); ?>

                                    </h4>
                                </div>
                                <div class="icon-shape bg-warning ">
                                    <i class="ti ti-calendar"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-sm-6">
                    <div class="card">
                        <div class="border rounded card-body border-primary bg-light-primary">
                            <div class="d-flex align-items-center">
                                <div class="numbers flex-grow-1">
                                    <p class="mb-1 fw-600 text-muted">فواتير الشهر الحالي</p>
                                    <h4 class="mb-0 fw-700 text-dark-black">
                                        <?php echo e(number_format($monthInvoicesTotal, 2)); ?>

                                        <span class="text-sm text-muted"><img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="20px" height="20px" alt=""></span>
                                    </h4>
                                </div>
                                <div class="icon-shape bg-primary ">
                                    <i class="ti ti-report-money"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>


            
            <div class="row mt-2">

                <div class="col-xl-3 col-sm-6">
                    <div class="card">
                        <div class="border rounded card-body border-secondary bg-light">
                            <div class="d-flex align-items-center">
                                <div class="numbers flex-grow-1 pe-3">
                                    <p class="mb-1 fw-600 text-muted">زيارات اليوم المكتملة</p>
                                    <h4 class="mb-0 fw-700 text-dark-black">
                                        <?php echo e($todayVisits); ?>

                                    </h4>
                                </div>
                                <div class="icon-shape bg-secondary ">
                                    <i class="ti ti-stethoscope"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-sm-6">
                    <div class="card">
                        <div class="border rounded card-body border-success bg-light">
                            <div class="d-flex align-items-center">
                                <div class="numbers flex-grow-1 pe-3">
                                    <p class="mb-1 fw-600 text-muted">الأطباء النشطين</p>
                                    <h4 class="mb-0 fw-700 text-dark-black">
                                        <?php echo e($activeDoctors); ?>

                                    </h4>
                                </div>
                                <div class="icon-shape bg-success ">
                                    <i class="fa fa-user-friends"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>


            
            <div class="row mt-3">

                
                <div class="col-xxl-4 col-lg-6 col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="mb-0">المواعيد خلال آخر 7 أيام</h4>
                        </div>
                        <div class="card-body">
                            <div id="appointments-chart" style="min-height: 280px;"></div>
                        </div>
                    </div>
                </div>

                
                <div class="col-xxl-8 col-lg-6 col-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h4 class="mb-0">إحصائيات المواعيد حسب الحالة</h4>
                        </div>
                        <div class="card-body">
                            <div id="appointments-status-chart" style="min-height: 280px;"></div>
                        </div>
                    </div>
                </div>

            </div>


            
            <div class="row mt-3">
                <div class="col-12">
                    <div class="card table-card">
                        <div class="card-header">
                            <h4>أحدث المواعيد</h4>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>المريض</th>
                                        <th>الدكتور</th>
                                        <th>التاريخ</th>
                                        <th>الوقت</th>
                                        <th>الحالة</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $latestAppointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $app): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($app->id); ?></td>
                                            <td><?php echo e($app->patient?->first_name ?? $app->patient?->name ?? '-'); ?></td>
                                            <td><?php echo e($app->doctor?->user?->name ?? '-'); ?></td>
                                            <td><?php echo e($app->appointment_date->format('Y-m-d')); ?></td>
                                            <td><?php echo e(\Carbon\Carbon::parse($app->start_time)->format('h:i A')); ?></td>

                                            <td>
                                                <?php
                                                    $status = $app->status;
                                                    $badgeClass = match ($status) {
                                                        'confirmed' => 'success',
                                                        'pending'   => 'warning',
                                                        'cancelled' => 'danger',
                                                        default     => 'secondary',
                                                    };
                                                ?>
                                                <span class="badge bg-<?php echo e($badgeClass); ?>">
                                                    <?php echo e($status); ?>

                                                </span>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="6" class="text-center text-muted">
                                                لا توجد مواعيد مسجلة.
                                            </td>
                                        </tr>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>
                </div>
            </div>


        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {

            // نتأكد إن ApexCharts متحمّل (من layout أو من ملف JS عام)
            if (typeof ApexCharts === 'undefined') {
                console.warn('ApexCharts not loaded');
                return;
            }



            const appointmentsData = <?php echo json_encode($appointmentsLast7Days ?? [], 15, 512) ?>;
            const appDates  = appointmentsData.map(item => item.date);
            const appCounts = appointmentsData.map(item => item.count);

            const appointmentsEl = document.querySelector('#appointments-chart');
            if (appointmentsEl) {
                const appointmentsOptions = {
                    chart: {
                        type: 'area',
                        height: 280,
                        toolbar: {show: false},
                        fontFamily: 'Cairo, sans-serif'
                    },
                    dataLabels: {enabled: false},
                    stroke: {
                        curve: 'smooth',
                        width: 3
                    },
                    series: [{
                        name: 'عدد المواعيد',
                        data: appCounts
                    }],
                    xaxis: {
                        categories: appDates,
                        labels: {
                            style: { fontFamily: 'Cairo, sans-serif' }
                        }
                    },
                    yaxis: {
                        labels: {
                            style: { fontFamily: 'Cairo, sans-serif' }
                        }
                    },
                    fill: {
                        opacity: 0.4
                    },
                    tooltip: {
                        y: { formatter: val => val + ' موعد' }
                    }
                };

                const appointmentsChart = new ApexCharts(appointmentsEl, appointmentsOptions);
                appointmentsChart.render();
            }


            const statusData   = <?php echo json_encode($appointmentsByStatus ?? [], 15, 512) ?>;
            const statusMap    = {
                'confirmed': 'مؤكد',
                'pending'  : 'قيد التأكيد',
                'cancelled': 'ملغى'
            };

            const statusLabels = statusData.map(item => statusMap[item.status] ?? item.status);
            const statusCounts = statusData.map(item => item.count);

            const statusEl = document.querySelector('#appointments-status-chart');
            if (statusEl) {
                const statusOptions = {
                    chart: {
                        type: 'pie',
                        height: 280,
                        fontFamily: 'Cairo, sans-serif'
                    },
                    labels: statusLabels,
                    series: statusCounts,
                    legend: {
                        position: 'bottom',
                        fontFamily: 'Cairo, sans-serif'
                    },
                    tooltip: {
                        y: { formatter: val => val + ' موعد' }
                    }
                };

                const statusChart = new ApexCharts(statusEl, statusOptions);
                statusChart.render();
            }

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\jops\SassMedical\resources\views/admin/index.blade.php ENDPATH**/ ?>