<?php
    use App\Helpers\RoleHelper;
?>

<aside class="app-sidebar app-light-sidebar" dir="rtl">
    <div class="app-navbar-wrapper">

        
        <div class="brand-link brand-logo">
            <a href="<?php echo e(route('dashboard.index')); ?>" class="b-brand">
                <img src="<?php echo e(asset('dash/assets/images/logo-dark.svg')); ?>" alt="Logo" class="logo logo-lg">
            </a>
        </div>

        <div class="navbar-content">
            <ul class="app-navbar">

                
                <li class="nav-item nav-hasmenu <?php echo e(request()->routeIs('dashboard.*') ? 'active' : ''); ?>">
                    <a href="#" class="nav-link">
                        <span class="nav-icon"><i class="ti ti-layout-2"></i></span>
                        <span class="nav-text">الصفحة الرئيسية</span>
                        <span class="nav-arrow"><i data-feather="chevron-left"></i></span>
                    </a>
                    <ul class="nav-submenu">
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(request()->routeIs('dashboard.index') ? 'active' : ''); ?>"
                               href="<?php echo e(route('dashboard.index')); ?>">
                                لوحة التحكم
                            </a>
                        </li>
                    </ul>
                </li>


                
                <li class="nav-item nav-caption">
                    <label>إدارة العيادة</label>
                </li>


                
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(RoleHelper::canSeePatients()): ?>
                    <li class="nav-item <?php echo e(request()->routeIs('patients.*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('patients.index')); ?>" class="nav-link">
                            <span class="nav-icon"><i class="ti ti-users"></i></span>
                            <span class="nav-text">المرضى</span>
                        </a>
                    </li>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>


                
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(RoleHelper::canSeeDoctors()): ?>
                    <li class="nav-item <?php echo e(request()->routeIs('doctors.*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('doctors.index')); ?>" class="nav-link">
                            <span class="nav-icon"><i class="fa fa-user-md"></i></span>
                            <span class="nav-text">الأطباء</span>
                        </a>
                    </li>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>


                
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(RoleHelper::canSeePatients()): ?>
                    <li class="nav-item nav-hasmenu
                        <?php echo e(request()->routeIs('services.*') || request()->routeIs('specialty.*') || request()->routeIs('treatment-plans.*') ? 'active nav-provoke' : ''); ?>">

                        <a href="#" class="nav-link">
                            <span class="nav-icon"><i class="fa fa-clipboard-check"></i></span>
                            <span class="nav-text">العلاجات والخدمات</span>
                            <span class="nav-arrow"><i data-feather="chevron-left"></i></span>
                        </a>

                        <ul class="nav-submenu">

                            <li class="nav-item <?php echo e(request()->routeIs('specialty.*') ? 'active' : ''); ?>">
                                <a class="nav-link" href="<?php echo e(route('specialty.index')); ?>">
                                    التخصصات الطبية
                                </a>
                            </li>

                            <li class="nav-item <?php echo e(request()->routeIs('services.*') ? 'active' : ''); ?>">
                                <a class="nav-link" href="<?php echo e(route('services.index')); ?>">
                                    الخدمات الطبية
                                </a>
                            </li>

                            <li class="nav-item <?php echo e(request()->routeIs('treatment-plans.*') ? 'active' : ''); ?>">
                                <a class="nav-link" href="<?php echo e(route('treatment-plans.index')); ?>">
                                    خطط العلاج
                                </a>
                            </li>

                        </ul>

                    </li>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>


                
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(RoleHelper::canSeeInvoices()): ?>
                    <li class="nav-item nav-hasmenu <?php echo e(request()->routeIs('invoices.*') ? 'active nav-provoke' : ''); ?>">
                        <a href="#" class="nav-link">
                            <span class="nav-icon"><i class="ti ti-receipt-2"></i></span>
                            <span class="nav-text">الفواتير والمالية</span>
                            <span class="nav-arrow"><i data-feather="chevron-left"></i></span>
                        </a>

                        <ul class="nav-submenu">
                            <li class="nav-item <?php echo e(request()->routeIs('invoices.*') ? 'active' : ''); ?>">
                                <a class="nav-link" href="<?php echo e(route('invoices.index')); ?>">
                                    الفواتير
                                </a>
                            </li>
                        </ul>
                    </li>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>


                
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(RoleHelper::canSeeInventory()): ?>
                    <li class="nav-item nav-hasmenu <?php echo e(request()->routeIs('inventory.*') ? 'active nav-provoke' : ''); ?>">
                        <a href="#" class="nav-link">
                            <span class="nav-icon"><i class="ti ti-box"></i></span>
                            <span class="nav-text">المخزون والصيدلية</span>
                            <span class="nav-arrow"><i data-feather="chevron-left"></i></span>
                        </a>

                        <ul class="nav-submenu">

                            <li class="nav-item <?php echo e(request()->routeIs('inventory.items.*') ? 'active' : ''); ?>">
                                <a class="nav-link" href="<?php echo e(route('inventory.items.index')); ?>">
                                    الأصناف
                                </a>
                            </li>

                            <li class="nav-item <?php echo e(request()->routeIs('inventory.movements.*') ? 'active' : ''); ?>">
                                <a class="nav-link" href="<?php echo e(route('inventory.movements.index')); ?>">
                                    حركات المخزون
                                </a>
                            </li>

                        </ul>
                    </li>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>


                
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(RoleHelper::canSeeSettings()): ?>
                    <li class="nav-item nav-caption">
                        <label>إعدادات النظام</label>
                    </li>

                    <li class="nav-item nav-hasmenu <?php echo e(request()->routeIs('settings.*') ? 'active nav-provoke' : ''); ?>">
                        <a href="#" class="nav-link">
                            <span class="nav-icon"><i class="ti ti-settings"></i></span>
                            <span class="nav-text">الإعدادات</span>
                            <span class="nav-arrow"><i data-feather="chevron-left"></i></span>
                        </a>

                        <ul class="nav-submenu">

                            <li class="nav-item <?php echo e(request()->routeIs('settings.users.*') ? 'active' : ''); ?>">
                                <a class="nav-link" href="<?php echo e(route('settings.users.index')); ?>">
                                    المستخدمون والصلاحيات
                                </a>
                            </li>

                            <li class="nav-item <?php echo e(request()->routeIs('settings.clinic.*') ? 'active' : ''); ?>">
                                <a class="nav-link" href="<?php echo e(route('settings.clinic.index')); ?>">
                                    بيانات العيادة
                                </a>
                            </li>

                        </ul>
                    </li>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            </ul>
        </div>

    </div>
</aside>
<?php /**PATH D:\jops\SassMedical\resources\views/admin/layouts/sidebar.blade.php ENDPATH**/ ?>