

<?php $__env->startSection('title'); ?>
    عرض بيانات الدكتور
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <?php
        $profile = $doctor->doctorProfile;
    ?>

    <div class="row">
        
        <div class="col-lg-4">
            <div class="card shadow-sm mb-4">
                <div class="card-body text-center">

                    
                    <img src="https://ui-avatars.com/api/?name=<?php echo e(urlencode($doctor->name)); ?>&size=150"
                         class="rounded-circle mb-3" alt="Doctor Avatar">

                    <h4><?php echo e($doctor->name); ?></h4>

                    <p class="text-muted mb-1">
                        <?php echo e($profile?->specialty?->name ?? 'بدون تخصص محدد'); ?>

                    </p>

                    <p class="mb-2">
                        <strong>العيادة:</strong>
                        <?php echo e($doctor->clinic?->name ?? '-'); ?><br>

                        <strong>الفرع:</strong>
                        <?php echo e($doctor->branch?->name ?? '-'); ?>

                    </p>

                    <p class="mb-2">
                        <strong>الحالة:</strong>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($doctor->is_active): ?>
                            <span class="badge bg-success">نشط</span>
                        <?php else: ?>
                            <span class="badge bg-danger">غير نشط</span>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </p>

                    <hr>

                    <p class="mb-2">
                        <strong>البريد:</strong> <?php echo e($doctor->email); ?> <br>
                        <strong>الجوال:</strong> <?php echo e($doctor->phone ?? '-'); ?>

                    </p>

                    <p class="text-muted mb-0">
                        <small>تاريخ التسجيل: <?php echo e($doctor->created_at?->format('Y-m-d')); ?></small>
                    </p>

                    <hr>

                    <a href="<?php echo e(route('doctors.edit', $doctor->id)); ?>"
                       class="btn btn-primary w-100">
                        تعديل بيانات الدكتور
                    </a>
                </div>
            </div>
        </div>

        
        <div class="col-lg-8">

            
            <div class="card shadow-sm mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">مواعيد الطبيب</h5>
                </div>
                <div class="card-body">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($profile && $profile->appointments->count()): ?>
                        <div class="table-responsive">
                            <table class="table table-sm table-striped align-middle">
                                <thead>
                                <tr>
                                    <th>#</th>
                                    <th>المريض</th>
                                    <th>التاريخ</th>
                                    <th>الوقت</th>
                                    <th>الحالة</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $profile->appointments->sortByDesc('appointment_date')->take(15); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $app): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($app->id); ?></td>
                                        <td><?php echo e($app->patient?->first_name  ?? '-'); ?></td>
                                        <td><?php echo e($app->appointment_date); ?></td>
                                        <td><?php echo e($app->start_time); ?></td>
                                        <td><?php echo e($app->status); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <p class="text-center text-muted mb-0">
                            لا توجد مواعيد مسجلة لهذا الطبيب.
                        </p>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
            </div>

            
            <div class="card shadow-sm mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">زيارات الطبيب</h5>
                </div>
                <div class="card-body">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($profile && $profile->visits->count()): ?>
                        <div class="table-responsive">
                            <table class="table table-sm table-striped align-middle">
                                <thead>
                                <tr>
                                    <th>#</th>
                                    <th>المريض</th>
                                    <th>تاريخ الزيارة</th>
                                    <th>الحالة</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $profile->visits->sortByDesc('visit_date')->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $visit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($visit->id); ?></td>
                                        <td><?php echo e($visit->patient?->first_name ?? '-'); ?></td>
                                        <td><?php echo e($visit->visit_date); ?></td>
                                        <td><?php echo e($visit->status ?? '-'); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <p class="text-center text-muted mb-0">
                            لا توجد زيارات مسجلة لهذا الطبيب.
                        </p>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
            </div>


            <div class="card shadow-sm mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">الروشتات المكتوبة</h5>
                </div>

                <div class="card-body">

                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($profile && $profile->prescriptions->count()): ?>

                        <div class="prescriptions-list">

                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $profile->prescriptions->sortByDesc('created_at')->take(15); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <div class="card mb-3 shadow-sm">
                                    <div class="card-header d-flex justify-content-between align-items-center">

                                        <div>
                                            <strong>روشتة رقم #<?php echo e($rx->id); ?></strong><br>
                                            <small class="text-muted">
                                                <?php echo e($rx->created_at->format('Y-m-d H:i')); ?>

                                                — للمريض: <?php echo e($rx->patient?->name ?? '-'); ?>

                                            </small>
                                        </div>
                                        <div class="d-flex gap-1">
                                            <button class="btn btn-sm btn-outline-primary"
                                                    onclick="document.getElementById('rx-<?php echo e($rx->id); ?>').classList.toggle('d-none')">
                                                عرض التفاصيل
                                            </button>

                                            <a href="<?php echo e(route('patients.prescriptions.print', $rx->id)); ?>"
                                               target="_blank"
                                               class="btn btn-sm btn-secondary">
                                                طباعة
                                            </a>
                                        </div>
                                    </div>

                                    <div class="card-body d-none" id="rx-<?php echo e($rx->id); ?>">

                                        
                                        <div class="rx-text">
                                            <?php echo $rx->notes; ?>

                                        </div>


                                    </div>
                                </div>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                        </div>

                    <?php else: ?>
                        <p class="text-center text-muted mb-0">
                            لا توجد روشتات مسجلة لهذا الطبيب.
                        </p>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                </div>
            </div>


        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\jops\SassMedical\resources\views/admin/doctors/show.blade.php ENDPATH**/ ?>