<?php $__env->startSection('title', 'خطة علاج رقم '.$plan->id); ?>

<?php $__env->startSection('content'); ?>

    <div class="content-header mb-3">
        <div class="d-flex justify-content-between align-items-center">
            <h5 class="mb-0">
                خطة علاج للمريض: <?php echo e($plan->patient?->first_name); ?> <?php echo e($plan->patient?->last_name); ?>

            </h5>

            <div class="d-flex gap-2">
                <a href="<?php echo e(route('patients.show', $plan->patient_id)); ?>" class="btn btn-sm btn-secondary">
                    رجوع لملف المريض
                </a>

                <form action="<?php echo e(route('treatment-plans.destroy', $plan->id)); ?>"
                      method="POST"
                      onsubmit="return confirm('هل تريد حذف هذه الخطة؟');">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button class="btn btn-sm btn-danger">حذف الخطة</button>
                </form>
            </div>
        </div>
    </div>


    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($errors->any()): ?>
        <div class="alert alert-danger">
            من فضلك صحح الأخطاء التالية:
            <ul class="mb-0">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $err): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($err); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </ul>
        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <?php
        $total = 0;
        foreach ($plan->items as $it) {
            $line = ($it->price - $it->discount) * $it->quantity;
            $total += max($line, 0);
        }
    ?>

    <div class="row gy-3">

        <div class="col-lg-4 col-12">
            <div class="card h-100">
                <div class="card-header">
                    <h6 class="mb-0">بيانات خطة العلاج</h6>
                </div>
                <div class="card-body">

                    <p class="mb-2"><strong>المريض:</strong>
                        <?php echo e($plan->patient?->first_name); ?> <?php echo e($plan->patient?->last_name); ?>

                        <br>
                        <small class="text-muted">كود: <?php echo e($plan->patient?->code ?? '-'); ?></small>
                    </p>

                    <p class="mb-2"><strong>الطبيب:</strong>
                        <?php echo e($plan->doctor?->user?->name ?? '-'); ?>

                    </p>

                    <span><strong>السن:</strong>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($plan->patient?->birth_date): ?>
                            <?php echo e(\Carbon\Carbon::parse($plan->patient->birth_date)->age); ?> سنة
                        <?php else: ?>
                            —
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </span>

                    <p class="mb-2"><strong>العنوان:</strong> <?php echo e($plan->title ?: '-'); ?></p>

                    <p class="mb-2"><strong>الحالة:</strong></p>

                    <form action="<?php echo e(route('treatment-plans.update-status', $plan->id)); ?>"
                          method="POST" class="d-flex align-items-center gap-2 mb-3">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PATCH'); ?>

                        <select name="status" class="form-select form-select-sm" style="max-width: 180px;">
                            <option value="draft" <?php echo e($plan->status == 'draft' ? 'selected' : ''); ?>>مسودة</option>
                            <option value="ongoing" <?php echo e($plan->status == 'ongoing' ? 'selected' : ''); ?>>جارية</option>
                            <option value="completed" <?php echo e($plan->status == 'completed' ? 'selected' : ''); ?>>مكتملة
                            </option>
                            <option value="cancelled" <?php echo e($plan->status == 'cancelled' ? 'selected' : ''); ?>>ملغاة
                            </option>
                        </select>

                        <button type="submit" class="btn btn-sm btn-outline-primary">
                            حفظ
                        </button>
                    </form>


                    <p class="mb-2"><strong>إجمالي تقديري:</strong>
                        <?php echo e(number_format($total, 2)); ?>

                        <small class="text-muted">ريال</small>
                    </p>

                    <p class="mb-0"><strong>ملاحظات الخطة:</strong><br>
                        <?php echo e($plan->description ?: '-'); ?>

                    </p>

                </div>
            </div>
        </div>

        
        <div class="col-lg-8 col-12">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">بنود خطة العلاج</h6>
                </div>
                <div class="card-body">

                    <form action="<?php echo e(route('treatment-plans.items.store', $plan->id)); ?>" method="POST" class="mb-3">
                        <?php echo csrf_field(); ?>

                        <div class="row g-2 align-items-end">

                            <div class="col-md-4">
                                <label class="form-label">الخدمة</label>
                                <select name="service_id" class="form-select">
                                    <option value="">اختر خدمة (اختياري)</option>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($service->id); ?>"
                                                data-price="<?php echo e($service->default_price); ?>"
                                            <?php echo e(old('service_id') == $service->id ? 'selected' : ''); ?>>
                                            <?php echo e($service->name); ?> - <?php echo e(number_format($service->default_price, 2)); ?>

                                        </option>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </select>
                            </div>

                            <div class="col-md-2">
                                <label class="form-label">السن</label>
                                <input type="text" name="tooth_number"
                                       class="form-control"
                                       value="<?php echo e($plan->patient?->birth_date != null ? \Carbon\Carbon::parse($plan->patient->birth_date)->age : ""); ?>"
                                >
                            </div>

                            <div class="col-md-2">
                                <label class="form-label">السطح</label>
                                <input type="text" name="surface"
                                       class="form-control"
                                       value="<?php echo e(old('surface')); ?>"
                                       placeholder="MO, DO...">
                            </div>

                            <div class="col-md-2">
                                <label class="form-label">العدد</label>
                                <input type="number" name="quantity" min="1"
                                       class="form-control"
                                       value="<?php echo e(old('quantity', 1)); ?>" required>
                            </div>

                            <div class="col-md-2">
                                <label class="form-label">السعر</label>
                                <input type="number" step="0.01" min="0"
                                       name="price" class="form-control"
                                       value="<?php echo e(old('price', 0)); ?>" readonly>
                            </div>

                            <div class="col-md-2 mt-2">
                                <label class="form-label">الخصم</label>
                                <input type="number" step="0.01" min="0"
                                       name="discount" class="form-control"
                                       value="<?php echo e(old('discount', 0)); ?>">
                            </div>

                            <div class="col-md-3 mt-2">
                                <label class="form-label">الحالة</label>
                                <select name="status" class="form-select" required>
                                    <option value="planned" <?php echo e(old('status') == 'planned' ? 'selected' : ''); ?>>
                                        مخطط
                                    </option>
                                    <option value="in_progress" <?php echo e(old('status') == 'in_progress' ? 'selected' : ''); ?>>
                                        جاري
                                    </option>
                                    <option value="done" <?php echo e(old('status') == 'done' ? 'selected' : ''); ?>>
                                        تم التنفيذ
                                    </option>
                                    <option value="cancelled" <?php echo e(old('status') == 'cancelled' ? 'selected' : ''); ?>>
                                        ملغي
                                    </option>
                                </select>
                            </div>

                            <div class="col-md-7 mt-2">
                                <label class="form-label">ملاحظات / تفاصيل البند</label>
                                <input type="text" name="notes"
                                       class="form-control"
                                       value="<?php echo e(old('notes')); ?>"
                                       placeholder="مثال: حشو عصب الضرس السادس علوي يمين...">
                            </div>

                        </div>

                        <button type="submit" class="btn btn-sm btn-primary mt-3">
                            إضافة البند إلى الخطة
                        </button>
                    </form>

                    <?php
                        $subtotal = 0;
                        $totalDiscount = 0;
                        $grandTotal = 0;

                        foreach ($plan->items as $item) {

                            $lineBase = $item->price * $item->quantity;


                            $discountAmount = $item->discount ?? 0;


                            if ($discountAmount > $lineBase) {
                                $discountAmount = $lineBase;
                            }

                            $lineTotal = $lineBase - $discountAmount;

                            $subtotal      += $lineBase;
                            $totalDiscount += $discountAmount;
                            $grandTotal    += $lineTotal;
                        }
                    ?>


                    
                    <div class="table-responsive">
                        <table class="table table-sm table-striped align-middle">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>الخدمة</th>
                                <th>السن / السطح</th>
                                <th>العدد</th>
                                <th>السعر</th>
                                <th>الخصم</th>
                                <th>الإجمالي</th>
                                <th>الحالة</th>
                                <th>الزيارة</th>
                                <th class="text-center">إجراءات</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $plan->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php
                                    $lineBase = $item->price * $item->quantity;
                                    $discountAmount = $item->discount ?? 0;

                                    if ($discountAmount > $lineBase) {
                                        $discountAmount = $lineBase;
                                    }

                                    $lineTotal = $lineBase - $discountAmount;

                                    $st = $item->status;
                                    $b = match($st) {
                                        'planned'     => 'secondary',
                                        'in_progress' => 'warning',
                                        'done'        => 'success',
                                        'cancelled'   => 'danger',
                                        default       => 'secondary',
                                    };
                                ?>
                                <tr>
                                    <td><?php echo e($item->id); ?></td>

                                    <td>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($item->service): ?>
                                            <?php echo e($item->service->name); ?>

                                        <?php else: ?>
                                            <span class="text-muted">—</span>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($item->notes): ?>
                                            <br>
                                            <small class="text-muted"><?php echo e($item->notes); ?></small>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </td>

                                    <td>
                                        <?php echo e($item->tooth_number ?: '-'); ?><br>
                                        <small class="text-muted"><?php echo e($item->surface ?: ''); ?></small>
                                    </td>

                                     <td><?php echo e($item->quantity); ?></td>

                                    <td>
                                        <?php echo e(number_format($item->price, 2)); ?>

                                        <small class="text-muted">
                                            <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="12" height="12" alt="">
                                        </small>
                                    </td>

                                    <td>
                                        <?php echo e(number_format($discountAmount, 2)); ?>

                                        <small class="text-muted">
                                            <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="12" height="12" alt="">
                                        </small>
                                    </td>

                                    <td>
                                        <?php echo e(number_format($lineTotal, 2)); ?>

                                        <small class="text-muted">
                                            <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="12" height="12" alt="">
                                        </small>
                                    </td>


                                    <td>
                                        <form action="<?php echo e(route('treatment-plans.items.update-status', $item->id)); ?>"
                                              method="POST" class="d-flex align-items-center gap-1">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PATCH'); ?>

                                            <select name="status" class="form-select form-select-sm">
                                                <option value="planned" <?php echo e($item->status == 'planned' ? 'selected' : ''); ?>>مخطط</option>
                                                <option value="in_progress" <?php echo e($item->status == 'in_progress' ? 'selected' : ''); ?>>جاري</option>
                                                <option value="done" <?php echo e($item->status == 'done' ? 'selected' : ''); ?>>تم</option>
                                                <option value="cancelled" <?php echo e($item->status == 'cancelled' ? 'selected' : ''); ?>>ملغي</option>
                                            </select>

                                            <button type="submit" class="btn btn-sm btn-outline-primary">
                                                ✔
                                            </button>
                                        </form>
                                    </td>


                                    <td>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($item->visit): ?>
                                            زيارة رقم <?php echo e($item->visit->id); ?><br>
                                            <small class="text-muted"><?php echo e($item->visit->visit_date ?? ''); ?></small>
                                        <?php else: ?>
                                            —
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </td>

                                    <td class="text-center">
                                        <form action="<?php echo e(route('treatment-plans.items.destroy', $item->id)); ?>"
                                              method="POST"
                                              onsubmit="return confirm('حذف هذا البند من الخطة؟');">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button class="btn btn-sm btn-danger">حذف</button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="10" class="text-center text-muted">لا توجد بنود مضافة لهذه الخطة بعد.
                                    </td>
                                </tr>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                            </tbody>
                            <tfoot>
                            <tr>
                                <th colspan="6" class="text-end">الإجمالي قبل الخصم</th>
                                <th colspan="4">
                                    <?php echo e(number_format($subtotal, 2)); ?>

                                    <small class="text-muted">
                                        <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="20" height="20" alt="">
                                    </small>
                                </th>
                            </tr>

                            <tr>
                                <th colspan="6" class="text-end">إجمالي الخصومات</th>
                                <th colspan="4">
                                    <?php echo e(number_format($totalDiscount, 2)); ?>

                                    <small class="text-muted">
                                        <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="20" height="20" alt="">
                                    </small>
                                </th>
                            </tr>

                            <tr class="table-success">
                                <th colspan="6" class="text-end fw-bold fs-5">الإجمالي النهائي</th>
                                <th colspan="4" class="fw-bold fs-5">
                                    <?php echo e(number_format($grandTotal, 2)); ?>

                                    <small class="text-muted">
                                        <img src="<?php echo e(asset('dash/Saudi_Riyal_Symbol.svg.png')); ?>" width="20" height="20" alt="">
                                    </small>
                                </th>
                            </tr>
                            </tfoot>


                        </table>
                    </div>

                </div>
            </div>
        </div>

    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script>
        document.addEventListener("DOMContentLoaded", function () {

            const serviceSelect = document.querySelector("select[name='service_id']");
            const priceInput = document.querySelector("input[name='price']");

            serviceSelect.addEventListener("change", function () {
                let selectedOption = this.options[this.selectedIndex];

                let price = selectedOption.getAttribute("data-price");

                if (!price) {
                    priceInput.value = 0;
                    return;
                }

                priceInput.value = price;
            });

        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\jops\SassMedical\resources\views/admin/treatment-plans/show.blade.php ENDPATH**/ ?>